package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.DiffOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.DiffOrderRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 收发差异单查询服务接口
 *
 * @author qiuzhi
 * @since 2021-05-24
 */
@Api(tags = {"库存中心：收发差异单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IDiffOrderQueryApi",
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/diff-order"
)
public interface IDiffOrderQueryApi {

    /**
     * 根据id查询收发差异单
     *
     * @param id 收发差异单id
     * @return   收发差异单数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询收发差异单", notes = "根据id查询收发差异单")
    RestResponse<DiffOrderRespDto> queryDiffOrderById(@PathVariable("id") Long id);

    /**
     * 收发差异单分页数据
     *
     * @param reqDto   收发差异单查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 收发差异单分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "收发差异单分页数据", notes = "根据查询条件查询收发差异单数据")
    RestResponse<PageInfo<DiffOrderRespDto>> queryDiffOrderByPage(@SpringQueryMap DiffOrderQueryReqDto reqDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
    /**
     * 根据id查询收发差异单明细
     *
     * @param id 收发差异单明细id
     * @return   收发差异单明细数据
     */
    @GetMapping("/detail/{id}")
    @ApiOperation(value = "根据id查询收发差异单明细", notes = "根据id查询收发差异单明细")
    RestResponse<DiffOrderDetailRespDto> queryDiffOrderDetailById(@PathVariable("id") Long id);

    /**
     * 收发差异单明细分页数据
     *
     * @param reqDto   收发差异单明细查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 收发差异单明细分页数据
     */
    @GetMapping("/detail/page")
    @ApiOperation(value = "收发差异单明细分页数据", notes = "根据查询条件查询收发差异单明细数据")
    RestResponse<PageInfo<DiffOrderDetailRespDto>> queryDiffOrderDetailByPage(@SpringQueryMap DiffOrderDetailQueryReqDto reqDto,
                                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
