package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author: liuji
 * @Date: 2020-06-22 11:12
 * @since 2.0.0
 */
@Api(tags = {"库存中心：订单路由规则查询服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/shop/route/rule")
public interface IOrderRouteRuleQueryApi {


    /**
     * 订单路由规则列表分页查询
     * @param orderRouteRuleQueryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @PostMapping("/page")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dto", value = "查询参数条件", dataType = "OrderRouteRuleQueryReqDto", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "当前页码", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "分页行数", dataType = "integer", paramType = "query")
    })
    @ApiOperation(value = "订单路由规则列表分页查询", notes = "订单路由规则列表分页查询")
    RestResponse<PageInfo<OrderRouteRuleRespDto>> queryRouteRulesByPage(@RequestBody OrderRouteRuleQueryReqDto orderRouteRuleQueryReqDto,
                                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据ID查询订单路由规则信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据ID主键查询订单路由规则信息", notes = "根据ID主键查询订单路由规则信息")
    RestResponse<OrderRouteRuleRespDto> queryRouteRuleById(@PathVariable("id") Long id);
}
