package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RefWarehousePageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RefWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
* 仓库关联表服务接口
*/
@Api(tags = {"仓库关联表服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v1/refWarehouse")
public interface IRefWarehouseQueryApi {

    /**
    * 根据id查询仓库关联表
    *
    * @param id 仓库关联表id
    * @return   仓库关联表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓库关联表", notes = "根据id查询仓库关联表")
    RestResponse<RefWarehouseRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 根据idS查询仓库关联表
    *
    * @return   仓库关联表数据
    */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据ids查询仓库关联表", notes = "根据ids查询仓库关联表")
    RestResponse<List<RefWarehouseRespDto>> queryByIds(@RequestBody List<Long> refWarehouseIds);
    
    /**
    * 仓库关联表分页数据
    *
    * @return 仓库关联表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "仓库关联表分页数据", notes = "根据filter查询条件查询仓库关联表数据，filter=RefWarehouseRespDto")
    RestResponse<PageInfo<RefWarehouseRespDto>> queryByPage(@ModelAttribute RefWarehousePageDto refWarehousePageReqDto, @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);

}
