package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RulePageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RuleRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
* 库存规则服务接口
*/
@Api(tags = {"库存规则服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/rule")
public interface IRuleQueryApi {

    /**
    * 根据id查询库存规则
    *
    * @param id 库存规则id
    * @return   库存规则数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询库存规则", notes = "根据id查询库存规则")
    RestResponse<RuleRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 根据idS查询库存规则
    *
    * @param ruleIds 配件id
    * @return   库存规则数据
    */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据ids查询库存规则", notes = "根据ids查询库存规则")
    RestResponse<List<RuleRespDto>> queryByIds(@RequestBody List<Long> ruleIds);
    
    /**
    * 库存规则分页数据
    *
    * @return 库存规则分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "库存规则分页数据", notes = "根据filter查询条件查询库存规则数据，filter=ruleDto")
    RestResponse<PageInfo<RuleRespDto>> queryByPage(@ModelAttribute RulePageReqDto rulePageReqDto, @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);

}
