package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageAdjustCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageAdjustRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 库存调整查询服务接口
 * @author: liuji
 * @Date: 2020-07-20 10:14
 * @since 2.0.0
 */
@Api(tags = {"库存中心：库存调整查询服务接口"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/storage/adjust")
public interface IStorageAdjustQueryApi {

    @GetMapping("/page")
    @ApiOperation(value = "分页查询库存调整信息", notes = "库存调整信息分页查询")
    RestResponse<PageInfo<StorageAdjustRespDto>> queryStorageAdjustByPage(@ModelAttribute StorageAdjustQueryReqDto storageAdjustQueryReqDto,
                                                                          @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "根据id查询库存调整信息",notes = "根据id查询库存调整信息")
    RestResponse<StorageAdjustRespDto> queryStorageAdjustById(@PathVariable("id") Long id);

    @GetMapping(value = "/{no}/cargo/page")
    @ApiOperation(value = "根据库存调整no查询库存调整货品(分页)",notes = "根据库存调整no查询库存调整货品(分页)")
    RestResponse<PageInfo<StorageAdjustCargoRespDto>> queryAdjustCargoByStorageAdjustNo(@PathVariable("no") String no,
                                                                                        @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                        @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
