package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageObjectQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageObjectRespDto;
import com.github.pagehelper.PageInfo;
import feign.QueryMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author: liuji
 * @Date: 2020-07-03 09:50
 * @since 2.0.0
 */
@Api(tags = {"库存中心：库存对象查询服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/storage/object")
public interface IStorageObjectQueryApi {

    /**
     * 库存对象列表分页查询
     * @param dto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/page")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dto", value = "查询参数条件", dataType = "StorageObjectQueryReqDto", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "当前页码", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "分页行数", dataType = "integer", paramType = "query")
    })
    @ApiOperation(value = "库存对象列表分页查询", notes = "库存对象列表分页查询")
    RestResponse<PageInfo<StorageObjectRespDto>> queryStorageObjectByPage(@QueryMap StorageObjectQueryReqDto dto,
                                                                          @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据ID主键查询库存对象信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据ID主键查询库存对象信息", notes = "根据ID主键查询库存对象信息")
    RestResponse<StorageObjectRespDto> queryStorageObjectById(@PathVariable("id") Long id);
}
