/*
 * @(#)IStorageOrderQueryApi.java 1.0 2018-09-07
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 出入库单查询接口
 *
 * @author 书生
 * @since 2.0.0
 */
@Api(tags = {"库存中心：出入库单查询服务接口"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/storage")
public interface IStorageOrderQueryApi {


    /**
     * 根据ID查询出入库单信息
     *
     * @param id 出入库单ID
     * @return StorageOrderCombineRespDto 入库单
     */
    @GetMapping(value = "/{id}", produces = "application/json")
    @ApiOperation(value = "查询出入库单", notes = "根据Id查询出入库单信息 \t\n id:出入库单Id \n" +
            "返回出入库查询响应组合Dto，组合Dto中包含了入库单dto、入库单明细Dto。")
    RestResponse<StorageOrderCombineRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据入库单ID查询入库单信息Eo
     *
     * @param filter  查询条件，json字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return StorageOrderCombineRespDto分页信息 出入库单Dto分页列表
     */
    @GetMapping(value = "/filterpage", produces = "application/json")
    @ApiOperation(value = "分页查询出入库单记录", notes = "出入库单记录 \n" +
            "过滤条件filter,对应StorageOrderReqDto,格式参考: \n" +
            "{\n" +
            "\"category\":\"CATEGORY_OUT\",   (入库CATEGORY_IN, 出库CATEGORY_OUT)\n" +
            "\"groupId\":123,\n" +
            "\"orderNo\":\"xxx\",\n" +
            "\"instanceId\":1,\n" +
            "\"tenantId\":1\n" +
            "}\n" +
            "返回出入库查询响应组合Dto分页信息，组合Dto中包含了入库单dto、入库单明细Dto")
    RestResponse<PageInfo<StorageOrderCombineRespDto>> queryFilterByPage(@RequestParam(name = "filter") String filter,
                                                                   @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 出入库单据分页数据
     *
     * @param storageOrderPageReqDto   出入库单据查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 出入库单据分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "出入库单据分页数据", notes = "根据filter查询条件查询出入库单据数据，filter=storageOrderDto")
    RestResponse<PageInfo<StorageOrderRespDto>> queryByPage(@ModelAttribute StorageOrderPageReqDto storageOrderPageReqDto,
                                                            @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
