package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.TransferOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.TransferOrderRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 查询服务接口
 *
 * @author qiuzhi
 * @since 2021-05-21
 */
@Api(tags = {"库存中心：调拨单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ITransferOrderQueryApi",
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/transfer-order"
)
public interface ITransferOrderQueryApi {

    /**
     * 根据id查询
     *
     * @param id id
     * @return   数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询调拨单", notes = "根据id查询调拨单")
    RestResponse<TransferOrderRespDto> queryTransferOrderById(@PathVariable("id") Long id);

    /**
     * 分页数据
     *
     * @param reqDto   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "调拨单分页数据", notes = "根据查询条件查询调拨单分页数据")
    RestResponse<PageInfo<TransferOrderRespDto>> queryTransferOrderByPage(@SpringQueryMap TransferOrderQueryReqDto reqDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);



    /**
     * 根据id查询
     *
     * @param id id
     * @return   数据
     */
    @GetMapping("/detail/{id}")
    @ApiOperation(value = "根据id查询调拨单明细", notes = "根据id查询调拨单明细")
    RestResponse<TransferOrderDetailRespDto> queryTransferOrderDetailById(@PathVariable("id") Long id);

    /**
     * 分页数据
     *
     * @param reqDto   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/detail/page")
    @ApiOperation(value = "调拨单明细分页数据", notes = "根据查询条件查询调拨单明细分页数据")
    RestResponse<PageInfo<TransferOrderDetailRespDto>> queryTransferOrderDetailByPage(@SpringQueryMap TransferOrderDetailQueryReqDto reqDto,
                                                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
