/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseCargoRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 仓库货品查询接口
 *
 * @author 浮云
 */
@Api(tags = {"库存中心：仓库货品查询服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/warehouse/cargo")
public interface IWarehouseCargoQueryApi {

    /**
     * 查询仓库货品信息
     *
     * @param warehouseCargoReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/page")
    @ApiOperation(value = "仓库货品查询", notes = "仓库货品查询")
    RestResponse<PageInfo<WarehouseCargoRespDto>> page(@ModelAttribute WarehouseCargoReqDto warehouseCargoReqDto,
                                                       @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                       @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 校验仓库货品数量
     *
     * @param cargoStorageCheckReqDto 仓库货品检查dto
     * @return
     */
    @PostMapping("/checkCargoStorage")
    @ApiOperation(value = "校验仓库货品数量", notes = "校验仓库货品数量")
    RestResponse<Void> checkCargoStorage(@RequestBody CargoStorageCheckReqDto cargoStorageCheckReqDto);


}