package com.dtyunxi.yundt.cube.center.inventory.api.utils;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.VariableUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.lang.reflect.Field;
import java.util.*;

/**
 * @(#)EoUtil.java 1.0 2018/3/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

public class EoUtil {
    private final static Logger logger = LoggerFactory.getLogger(EoUtil.class);

    @SuppressWarnings("unused")
    private static Map<String, Field[]> filedMap = new HashMap<>();
    @SuppressWarnings("unused")
    private static Object createFieldSqlLock = new Object();


    public static void main(String[] str) {
        List<PartsDto> list = new ArrayList<PartsDto>();
        PartsDto dto = new PartsDto();
        dto.setCode("35235");
        dto.setId(1231L);
        list.add(dto);
        System.out.print(JSON.toJSONString(listToMap(list, "id", Long.class)));
    }

    public static String createDistinctIdsStringByLong(List<Long> ids) {
        return createDistinctIdsStringByLong(ids.toArray(new Long[0]));
    }

    public static String createDistinctIdsStringByLong(Long[] ids) {
        if (ids == null) {
            return "";
        }
        Set<String> set = new HashSet<String>(ids.length);
        for (Long id : ids) {
            set.add(id.toString());
        }

        StringBuilder sb = new StringBuilder();
        for (String id : set) {
            sb.append(",").append(id);
        }
        return sb.substring(1, sb.length());
    }

    /**
     * 选择list里的对象的某个字段作为KEY创建该对象的 MAP
     *
     * @param <T>
     * @param <E>
     * @param list
     * @param keyField
     * @return
     */
    public static <T, E> Map<E, T> listToMap(List<T> list, String keyField, Class<E> keyClazz) {
        if (null == list) {
            return null;
        }
        Map<E, T> resultMap = new HashMap<E, T>();
        for (T obj : list) {
            if (ReflectionUtil.isExistGetter(obj, keyField)) {
                E key = ReflectionUtil.invokeGetterAndConvert(obj, keyField, keyClazz);
                if (key != null) {
                    resultMap.put(key, obj);
                } else {
                    logger.warn("属性：[" + keyField + "] 的值为null,将不存入Map");
                }

            } else {
                logger.warn("属性：[" + keyField + "] 找不到getter方法");
            }

        }
        return resultMap;
    }

    /**
     * @param <T>
     * @param eoPageInfo
     * @param targetClazz
     * @return
     */
    public static <T extends BaseVo> PageInfo<T> eoPageToDtoPage(PageInfo<? extends BaseEo> eoPageInfo, Class<T> targetClazz) {
        if (null == eoPageInfo) {
            return null;
        }

        List<T> list = new ArrayList<>();
        CubeBeanUtils.copyCollection(list, eoPageInfo.getList(), targetClazz);
        PageInfo<T> dtoPageInfo = new PageInfo<>();
        BeanUtils.copyProperties(eoPageInfo, dtoPageInfo);
        dtoPageInfo.setList(list);
        return dtoPageInfo;
    }


    /**
     * @param <T>
     * @param baseEo
     * @param targetClazz
     * @return
     */
    public static <T extends BaseVo> T eoToDto(BaseEo baseEo, Class<T> targetClazz) {
        if (null == baseEo) {
            return null;
        }

        T target = null;
        try {
            target = targetClazz.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        }
        DtoHelper.eo2Dto(baseEo, target);
        return target;
    }

    public static <T extends BaseEo> T dtoToEo(BaseVo baseVo, Class<T> targetClazz) {
        if (null == baseVo) {
            return null;
        }

        T target = null;
        try {
            target = targetClazz.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        }
        DtoHelper.dto2Eo(baseVo, target, "");
        return target;
    }

    /**
     * @param <T>
     * @param dtoList
     * @param eoClass
     * @return
     */
    public static <T extends BaseEo> List<T> dtoListToEoList(Collection<? extends BaseVo> dtoList, Class<T> eoClass) {
        if (null == dtoList) {
            return null;
        }
        List<T> list = new ArrayList<>();
        DtoHelper.dtoList2EoList(dtoList, list, eoClass);
        return list;
    }

    public static <T extends BaseVo> List<T> eoListToDtoList(Collection<? extends BaseEo> eoList, Class<T> eoClass) {
        if (null == eoList) {
            return null;
        }
        List<T> list = new ArrayList<>();
        DtoHelper.eoList2DtoList(eoList, list, eoClass);
        return list;
    }

    public static void setNullVal(Object obj, String... fieldNames) {
        setVal(obj, null, fieldNames);
    }

    public static void setVal(Object dto, Object val, String... fieldNames) {
        for (String fieldName : fieldNames) {
            if (ReflectionUtil.isExistSetter(dto, fieldName)) {
                ReflectionUtil.invokeSetter(dto, fieldName, val);
            } else {
                logger.warn("属性：[" + fieldName + "] 找不到Setter方法");
            }

        }
    }

    @SuppressWarnings("unused")
    private static String createFieldSql(Class<? extends BaseEo> eo, String[] alias) {
        Alias fa = createFieldAlias();
        for (String aliasOpt : alias) {
            String[] aliasArray = aliasOpt.split(" as ");
            if (aliasArray.length != 2) {
                throw new RuntimeException("别名配置出错：[%s] 不符合 \" xxx as xxx\" 的格式");
            }
            fa.add(aliasArray[0], aliasArray[1]);
        }

        return createFieldSql(eo, fa);
    }

    public static String createFieldSql(Class<? extends BaseEo> eo, Alias alias) {
        return createFieldSql(eo, alias.getAliasMap());
    }

    public static String createFieldSql(Class<? extends BaseEo> eo, Map<String, String> aliasMap) {
        List<Field> fields = ReflectionUtil.getDeclaredFieldsUseCache(eo);
        StringBuilder sql = new StringBuilder();
        String tableAlias = getEoTableAlias(eo, aliasMap);

        for (Field field : fields) {
            String fieldName = getDbFieldName(field);
            if (fieldName != null) {
                appendField(sql, fieldName, tableAlias, field, eo, aliasMap);
            }
        }
        return sql.substring(0, sql.length() - 1);
    }

    private static void appendField(StringBuilder sql, String fieldName, String tableAlias, Field field, Class<? extends BaseEo> eo, Map<String, String> aliasMap) {
        String aliasName = getAliasName(fieldName, field, eo, aliasMap);
        if (aliasName == null) {
            sql.append(tableAlias).append(".").append(fieldName).append(", ");
        } else {
            sql.append(tableAlias).append(".").append(fieldName).append(" as ").append(aliasName).append(", ");
        }
    }

    private static String getAliasName(String fieldName, Field field, Class<? extends BaseEo> eo, Map<String, String> aliasMap) {
        String aliasName = aliasMap.get(fieldName);

        if (StringUtils.isBlank(aliasName)) {
            aliasName = aliasMap.get(field.getName());
        }

        if (StringUtils.isBlank(aliasName) && isBaseEoField(field)) {
            aliasName = getEoTableName(eo).concat("_").concat(fieldName);
        }

        return aliasName;
    }

    private static Boolean isBaseEoField(Field field) {
        List<Field> fields = ReflectionUtil.getDeclaredFields(BaseEo.class);
        for (Field baseField : fields) {
            Column column = baseField.getAnnotation(Column.class);
            Id id = field.getAnnotation(Id.class);
            if (column != null || id != null) {
                if (StringUtils.equals(baseField.getName(), field.getName())) {
                    return true;
                }
            }
        }
        return false;
    }

    private static String getEoTableAlias(Class<? extends BaseEo> eo, Map<String, String> aliasMap) {
        String alias = aliasMap.get(eo.getSimpleName());
        if (alias == null) {
            alias = "";
            String name = getEoTableName(eo);
            String[] names = name.split("_");
            for (String s : names) {
                alias = alias.concat(s.substring(0, 1));
            }
        }
        return alias;
    }

    private static String getEoTableName(Class<? extends BaseEo> eo) {
        Table table = eo.getAnnotation(Table.class);
        return table.name();
    }

    private static String getDbFieldName(Field field) {
        String reslut = null;
        Column column = field.getAnnotation(Column.class);

        if (column != null) {
            reslut = column.name();
        } else {
            Id id = field.getAnnotation(Id.class);
            if (id != null) {
                reslut = VariableUtil.underscoreName(field.getName());
            }
        }

        return reslut;
    }

    public static Alias createFieldAlias() {
        return new Alias();
    }

    public static class PartsDto extends RequestDto {
        /**
         *
         */
        private static final long serialVersionUID = 1L;
        private Long id;
        private Long dealerId;
        private String code;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getDealerId() {
            return dealerId;
        }

        public void setDealerId(Long dealerId) {
            this.dealerId = dealerId;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public static class Alias {
        private Class<?> eoClazz;
        private Map<String, String> map = new HashMap<String, String>();

        private Alias() {

        }

        private Alias(Class<?> eoClazz) {
            this.eoClazz = eoClazz;
        }

        public Alias add(String fieldName, String aliasName) {
            map.put(fieldName, aliasName);
            return this;
        }

        public Map<String, String> getAliasMap() {
            return map;
        }

    }

}
