package com.dtyunxi.yundt.cube.center.inventory.api.utils;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * 使用方法1：
 * SqlFilterBuilder.create(MemberEo.class).eq("id ", 11).eo()
 * 
 * 使用方法2:
 * SqlFilterBuilder.create().eq("id ", 11).filters()
 * 
 * @author 林建忠<303495267@qq.com>
 *
 * @param <T>
 */
public class SqlFilterBuilder<T extends BaseEo> {

	private List<SqlFilter> filters = new ArrayList<>();
	private T eo;
	public SqlFilterBuilder(){
		
	}
	
	public SqlFilterBuilder(Class<T> clazz) throws InstantiationException, IllegalAccessException{
		this.eo = clazz.newInstance();
		this.eo.setSqlFilters(filters);
	}
	public static SqlFilterBuilder<BaseEo> create(){
		return new SqlFilterBuilder<BaseEo>();
	}
	
	public static <T extends BaseEo> SqlFilterBuilder<T> create(Class<T> clazz){
		try {
			return new SqlFilterBuilder<T>(clazz);
		} catch (InstantiationException | IllegalAccessException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public SqlFilterBuilder<T> eq(String property, Object value){
		if(isAdd(property, value)){
			filters.add(SqlFilter.eq(property, value));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> ge(String property, Object value){
		if(isAdd(property, value)){
			filters.add(SqlFilter.ge(property, value));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> gt(String property, Object value){
		if(isAdd(property, value)){
			filters.add(SqlFilter.gt(property, value));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> in(String property, Object value){
		if(isAdd(property, value)){
			filters.add(SqlFilter.in(property, value));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> in(String property, List<Long> ids){
		if(isAdd(property, ids) && CollectionUtils.isNotEmpty(ids)){
			filters.add(SqlFilter.in(property, EoUtil.createDistinctIdsStringByLong(ids)));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> isNotNull(String property){
		if(isAdd(property)){
			filters.add(SqlFilter.isNotNull(property));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> isNull(String property){
		if(isAdd(property)){
			filters.add(SqlFilter.isNull(property));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> le(String property, Object value){
		if(isAdd(property,value)){
			filters.add(SqlFilter.le(property,value));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> like(String property, Object value){
		if(isAdd(property,value)){
			filters.add(SqlFilter.like(property,value));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> lt(String property, Object value){
		if(isAdd(property,value)){
			filters.add(SqlFilter.lt(property,value));
		}
		return this;
	}
	
	public SqlFilterBuilder<T> ne(String property, Object value){
		if(isAdd(property,value)){
			filters.add(SqlFilter.ne(property,value));
		}
		return this;
	}
	
	
	public List<SqlFilter> filters(){
		return filters;
	}
	
	public T eo(){
		return this.eo;
	}
	
	private boolean isAdd(String property, Object value){
		return property != null && value != null;
	}
	
	private boolean isAdd(String property){
		return property != null;
	}
	
	public static void main(String[] args) {
		SqlFilterBuilder.create()
		.le("xxx", 111)
		.like("ccc", "xxx")
		.in("ccc", "xx,xx");
	}
	
	public static String idsToString(List<Long> ids){
		return EoUtil.createDistinctIdsStringByLong(ids);
	}
}
