/*
 * IPackageApi.class 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 包裹物流管理服务
 *
 * @author 纳兰
 * @since 2.0.0
 */
@Api(tags = {"库存中心：包裹物流管理服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/package")
public interface IPackageApi {
    /**
     * 手动修改发货单拆包情况
     *
     * @param packageReqDto 手动修改发货单拆包情况Dto
     * @return 操作结果
     */
    @PutMapping(value = "", produces = "application/json")
    @ApiOperation(value = "手动修改发货单拆包情况", notes = "手动修改发货单拆包情况 \t\n packageReqDto:手动修改发货单拆包情况Dto")
    RestResponse<Void> modifyPackage(@Valid @RequestBody PackageReqDto packageReqDto);

    /**
     * 修改包裹信息
     *
     * @param id         包裹id
     * @param packageDto 修改包裹信息请求Dto
     * @return 操作结果
     */
    @PutMapping(value = "/{id}", produces = "application/json")
    @ApiOperation(value = "修改包裹信息", notes = "修改包裹信息 \t\n id:包裹id \t\n packageReqDto:修改包裹信息请求Dto")
    RestResponse<Void> modifyPackage(@PathVariable("id") Long id, @RequestBody PackageModReqDto packageDto);

    /**
     * 打包包裹
     *
     * @param id           包裹id
     * @param packedReqDto 打包包裹请求Dto
     * @return 操作结果
     */
    @PutMapping(value = "/{id}/packed", produces = "application/json")
    @ApiOperation(value = "打包包裹", notes = "打包包裹 \t\n id:包裹id \t\n packedReqDto:打包包裹请求Dto")
    RestResponse<Void> packed(@PathVariable("id") Long id, @RequestBody PackagePackedReqDto packedReqDto);

    /**
     * 新增拆包配置
     *
     * @param packageSplitConfigCreateReqDto 拆包配置创建Dto
     * @return Long 主键ID
     */
    @PostMapping(value = "/split-config", produces = "application/json")
    @ApiOperation(value = "新增拆包配置", notes = "新增拆包配置 \t\n packageSplitConfigQueryReqDto:拆包配置请求Dto")
    RestResponse<Long> addPackageSplitConfig(@Valid @RequestBody PackageSplitConfigCreateReqDto packageSplitConfigCreateReqDto);


    /**
     * 修改拆包配置信息
     *
     * @param id                             主键ID
     * @param packageSplitConfigUpdateReqDto 拆包配置更新Dto
     * @return 操作结果
     */
    @PutMapping(value = "/split-config/{id}", produces = "application/json")
    @ApiOperation(value = "修改拆包配置信息", notes = "修改拆包配置信息 \t\n id:拆包配置id \t\n packageSplitConfigQueryReqDto:拆包配置请求Dto")
    RestResponse<Void> modifyPackageSplitConfig(@NotNull(message = "拆包配置id不能为空") @PathVariable("id") Long id,
                                                @Valid @RequestBody PackageSplitConfigUpdateReqDto packageSplitConfigUpdateReqDto);

    /**
     * 根据id删除拆包配置
     *
     * @param id     拆包配置ids
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @DeleteMapping(value = "/split-config/{id}", produces = "application/json")
    @ApiOperation(value = "根据id删除拆包配置", notes = "根据id删除拆包配置 \t\n id:拆包配置id " +
            "\t\n filter {\"instanceId\":0,\"tenantId\":1}")
    RestResponse<Void> removeConfigById(@NotNull(message = "拆包配置id不能为空") @PathVariable("id") Long id,
                                        @RequestParam("filter") String filter);

    /**
     * 根据code删除拆包配置
     *
     * @param code   编码
     * @param filter {"instanceId":0,"tenantId":1}
     * @return 操作结果
     */
    @DeleteMapping(value = "/split-config/code/{code}", produces = "application/json")
    @ApiOperation(value = "根据code删除拆包配置", notes = "根据code删除拆包配置 \t\n code:拆包配置编码code " +
            "\t\n filter {\"instanceId\":0,\"tenantId\":1}")
    RestResponse<Void> removeConfigByCode(@NotNull(message = "拆包配置code不能为空") @PathVariable("code") String code,
                                          @RequestParam("filter") String filter);

}
