/*
 * @(#)IShippingPartnerCompanyApi.java 1.0 2018-12-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerCompanyModifyReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerCompanyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 渠道和物流公司关联关系表 api
 *
 * @author 简树
 * @since 2.0.0
 */

@Api(tags = {"库存中心:"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v1/inventory")
public interface IShippingPartnerCompanyApi {
    /**
     * 新增渠道和物流公司关联关系表
     *
     * @param dto
     * @return
     */
    @PostMapping("/check")
    @ApiOperation(value = "新增渠道和物流公司关联关系表", notes = "新增渠道和物流公司关联关系表 返回主键id")
    RestResponse<Long> addShippingPartnerCompany(@Valid @RequestBody ShippingPartnerCompanyReqDto dto);

    /**
     * 修改 渠道和物流公司关联关系表
     *
     * @param id
     * @param dto 修改内容
     * @return
     */
    @PutMapping("/check/{id}")
    @ApiOperation(value = "修改渠道和物流公司关联关系", notes = "新增渠道和物流公司关联关系表/新增渠道和物流公司关联关系表")
    RestResponse<Void> updateShippingPartnerCompany(@NotNull(message = "id不能为空") @PathVariable("id") Long id, @Valid @RequestBody ShippingPartnerCompanyModifyReqDto dto);
}
