/**
 * @(#)PackageStatusEnum.java 1.0 2018年8月31日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shipping.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 包裹状态
 *
 * @author 水镜
 * @since 2.0.0
 */
public enum PackageStatusEnum {
    INIT("INIT", "初始化"),
    PACKED("PACKED", "已打包"),
    SEND_OUT("SEND_OUT", "已发货"),
    WAIT_OUT("WAIT_OUT", "待出库"),
    CANCEL("CANCEL", "已取消"),
    SIGNED("SIGNED", "已签收");

    private final String code;
    private final String text;

    PackageStatusEnum(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public String getCode() {
        return code;
    }


    public String getText() {
        return text;
    }

    /**
     * 根据code获取text
     *
     * @param code
     *            状态编码
     * @return 状态说明
     */
    public static String getText(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        for (PackageStatusEnum transferApplyStatusEnum : PackageStatusEnum.values()) {
            if (code.equals(transferApplyStatusEnum.getCode())) {
                return transferApplyStatusEnum.getText();
            }
        }
        return null;
    }

}
