/**
 * @(#)PartnerConfigStatusEnum.java 1.0 2018年8月31日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shipping.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 渠道配置状态
 *
 * @author 水镜
 * @since 2.0.0
 */
public enum PartnerConfigStatusEnum {

    ENABLED("ENABLED", "启用"),
    DISABLED("DISABLED", "禁用");

    private final String code;
    private final String text;

    PartnerConfigStatusEnum(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public String getCode() {
        return code;
    }


    public String getText() {
        return text;
    }

    /**
     * 根据code获取text
     *
     * @param code
     *            状态编码
     * @return 状态说明
     */
    public static String getText(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        for (PartnerConfigStatusEnum transferApplyStatusEnum : PartnerConfigStatusEnum.values()) {
            if (code.equals(transferApplyStatusEnum.getCode())) {
                return transferApplyStatusEnum.getText();
            }
        }
        return null;
    }

}
