/*
 * @(#)InventoryException.java 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 运费计算请求参数Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "CargoDetailReqDto", description = "货品列表Dto")
public class CargoDetailReqDto extends BaseVo {

    /**
     * 货品id
     */
    @NotNull(message = "货品id不能为空")
    @ApiModelProperty(name = "cargoId", value = "货品id，必填")
    private Long cargoId;

    /**
     * 货品数量
     */
    @Min(value = 1, message = "货品数量不能少于1")
    @ApiModelProperty(name = "num", value = "货品数量，必填，不能少于1")
    private Long num;

    /**
     * 运费模板id
     */
    @NotNull(message = "运费模板id不能为空")
    @ApiModelProperty(name = "shippingTplId", value = "运费模板id不能为空，必填")
    private Long shippingTplId;

    /**
     * 重量
     */
    @NotNull(message = "货品重量不能为空")
    @ApiModelProperty(name = "quantity", value = "重量，必填")
    private BigDecimal quantity;

    /**
     * 体积
     */
    @NotNull(message = "货品体积不能为空")
    @ApiModelProperty(name = "volume", value = "体积，必填")
    private BigDecimal volume;


    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getNum() {
        return num;
    }

    public void setNum(Long num) {
        this.num = num;
    }

    public Long getShippingTplId() {
        return shippingTplId;
    }

    public void setShippingTplId(Long shippingTplId) {
        this.shippingTplId = shippingTplId;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }
}