/*
 * FreightForCargoReqDto.class 2.0 2018-10-08
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 根据货品列表计算运费请求参数模板Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "FreightForCargoReqDto", description = "根据货品列表计算运费请求参数模板Dto")
public class FreightForCargoReqDto extends BaseVo {

    @NotNull(message = "货品列表不能为空")
    @ApiModelProperty(name = "cargoDetailReqDtos", value = "货品列表Dto，必填")
    private List<CargoDetailReqDto> cargoDetailReqDtos;

    @NotNull(message = "实例id不能为空")
    @ApiModelProperty(name = "instanceId", value = "实例id，必填")
    private Long instanceId;

    @NotNull(message = "租户id不能为空")
    @ApiModelProperty(name = "tenantId", value = "租户id，必填")
    private Long tenantId;

    public List<CargoDetailReqDto> getCargoDetailReqDtos() {
        return cargoDetailReqDtos;
    }

    public void setCargoDetailReqDtos(List<CargoDetailReqDto> cargoDetailReqDtos) {
        this.cargoDetailReqDtos = cargoDetailReqDtos;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}