/*
 * FreightForOrderReqDto.class 2.0 2018-10-08
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 根据订单列表计算运费请求参数模板Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "FreightForOrderReqDto", description = "根据订单列表计算运费请求参数模板Dto")
public class FreightForOrderReqDto extends BaseVo {

    @NotNull(message = "订单列表不能为空")
    @ApiModelProperty(name = "orderDetailReqDtos", value = "订单列表Dto，必填")
    private List<OrderDetailReqDto> orderDetailReqDtos;

    @NotNull(message = "实例id不能为空")
    @ApiModelProperty(name = "instanceId", value = "实例id，必填")
    private Long instanceId;

    @NotNull(message = "租户id不能为空")
    @ApiModelProperty(name = "tenantId", value = "租户id，必填")
    private Long tenantId;

    public List<OrderDetailReqDto> getOrderDetailReqDtos() {
        return orderDetailReqDtos;
    }

    public void setOrderDetailReqDtos(List<OrderDetailReqDto> orderDetailReqDtos) {
        this.orderDetailReqDtos = orderDetailReqDtos;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}