/*
 * @(#)InventoryException.java 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 运费计算请求参数DTO--订单列表
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "OrderDetailReqDto", description = "运费计算请求参数DTO--订单列表")
public class OrderDetailReqDto extends BaseVo {

    /**
     * 订单id
     */
    @NotNull(message = "订单id不能为空")
    @ApiModelProperty(name = "orderId", value = "订单id，必填")
    private Long orderId;

    /**
     * 货品详情列表
     */
    @Valid
    @NotNull(message = "货品列表不能为空")
    @ApiModelProperty(name = "cargoDetailReqDtos", value = "货品详情列表，必填")
    private List<CargoDetailReqDto> cargoDetailReqDtos;

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public List<CargoDetailReqDto> getCargoDetailReqDtos() {
        return cargoDetailReqDtos;
    }

    public void setCargoDetailReqDtos(List<CargoDetailReqDto> cargoDetailReqDtos) {
        this.cargoDetailReqDtos = cargoDetailReqDtos;
    }
}