/*
 * PackageDto.class 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 包裹响应Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "PackageDto", description = "包裹响应Dto")
public class PackageDto extends RequestDto {
    @ApiModelProperty(name = "id", value = "包裹id")
    private Long id;
    /**
     * 发货单ID
     */
    @ApiModelProperty(name = "deliveryOrderId", value = "发货单ID")
    private Long deliveryOrderId;
    /**
     * 发货单编码
     */
    @ApiModelProperty(name = "deliveryOrderNo", value = "发货单编码")
    private String deliveryOrderNo;
    /**
     * 包裹编码
     */
    @ApiModelProperty(name = "packageNo", value = "包裹编码")
    @NotNull(message = "包裹编码不能为空")
    private String packageNo;
    /**
     * 物流单号
     */
    @ApiModelProperty(name = "shippingNo", value = "物流单号")
    private String shippingNo;
    /**
     * INIT初始化 PACKED已打包  SEND_OUT已发货 SIGNED已签收 CANCEL 已取消 WAIT_OUT 待出库
     */
    @ApiModelProperty(name = "status", value = "包裹状态：INIT初始化 PACKED已打包  SEND_OUT已发货 SIGNED已签收 CANCEL 已取消 WAIT_OUT 待出库")
    private String status;


    /**
     * BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量 BY_ORDER按订单
     */
    @ApiModelProperty(name = "computeMode", value = "技术模板：BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量")
    @NotNull(message = "计算模板不能为空")
    private String computeMode;
    /**
     * 包裹规格
     */
    @ApiModelProperty(name = "spec", value = "包裹规格")
    @NotNull(message = "包裹规格不能为空")
    private String spec;

    /**
     * 运费
     */
    @ApiModelProperty(name = "freight", value = "运费")
    @NotNull(message = "运费不能为空")
    private BigDecimal freight;

    /**
     * 收件人
     */
    @ApiModelProperty(name = "recipients", value = "收件人")
    @NotNull(message = "收件人不能为空")
    private String recipients;

    /**
     * 省编码
     */
    @ApiModelProperty(name = "provCode", value = "省编码")
    @NotNull(message = "省编码不能为空")
    private String provCode;

    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码")
    @NotNull(message = "市编码不能为空")
    private String cityCode;

    /**
     * 快递公司id
     */
    @ApiModelProperty(name = "shippingCompanyId", value = "快递公司id")
    private Long shippingCompanyId;

    public Long getShippingCompanyId() {
        return shippingCompanyId;
    }

    public void setShippingCompanyId(Long shippingCompanyId) {
        this.shippingCompanyId = shippingCompanyId;
    }


    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码")
    @NotNull(message = "区编码不能为空")
    private String areaCode;

    /**
     * 详细地址
     */
    @ApiModelProperty(name = "address", value = "详细地址")
    @NotNull(message = "详细地址不能为空")
    private String address;


    public String getPackageNo() {
        return packageNo;
    }

    public void setPackageNo(String packageNo) {
        this.packageNo = packageNo;
    }

    public String getShippingNo() {
        return shippingNo;
    }

    public void setShippingNo(String shippingNo) {
        this.shippingNo = shippingNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    public String getComputeMode() {
        return computeMode;
    }

    public void setComputeMode(String computeMode) {
        this.computeMode = computeMode;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public String getRecipients() {
        return recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public String getProvCode() {
        return provCode;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 包裹详情
     */
    @ApiModelProperty(name = "packageDetailDtos", value = "包裹详情")
    @NotNull(message = "包裹详情不能为空")
    List<PackageDetailDto> packageDetailDtos;

    public List<PackageDetailDto> getPackageDetailDtos() {
        return packageDetailDtos;
    }

    public void setPackageDetailDtos(List<PackageDetailDto> packageDetailDtos) {
        this.packageDetailDtos = packageDetailDtos;
    }

    public Long getDeliveryOrderId() {
        return deliveryOrderId;
    }

    public void setDeliveryOrderId(Long deliveryOrderId) {
        this.deliveryOrderId = deliveryOrderId;
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
