/*
 * PackageDto.class 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 打包包裹Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "PackagePackedReqDto", description = "打包包裹Dto")
public class PackagePackedReqDto extends BaseVo {
    @ApiModelProperty(name = "id", value = "包裹id，不填，参数值无效")
    private Long id;
    /**
     * 物流单号
     */
    @ApiModelProperty(name = "shippingNo", value = "物流单号，当参数shippingCompanyId值不为空时，必填")
    private String shippingNo;
    /**
     * 快递公司id
     */
    @ApiModelProperty(name = "shippingCompanyId", value = "快递公司id，选填")
    private Long shippingCompanyId;

    public Long getShippingCompanyId() {
        return shippingCompanyId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getShippingNo() {
        return shippingNo;
    }

    public void setShippingNo(String shippingNo) {
        this.shippingNo = shippingNo;
    }

    public void setShippingCompanyId(Long shippingCompanyId) {
        this.shippingCompanyId = shippingCompanyId;
    }
}
