/*
 * PackageReqDto.class 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 包裹请求Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "PackageReqDto", description = "包裹请求Dto")
public class PackageReqDto extends BaseVo {
    /**
     * 发货单ID
     */
    @ApiModelProperty(name = "deliveryOrderId", value = "发货单ID，必填")
    @NotNull(message = "发货单ID不能为空")
    private Long deliveryOrderId;

    /**
     * 发货单编码
     */
    @ApiModelProperty(name = "deliveryOrderNo", value = "发货单编码，必填")
    @NotNull(message = "发货单编码不能为空")
    private String deliveryOrderNo;

    /**
     * 交易订单ID
     */
    @ApiModelProperty(name = "orderId", value = "交易订单ID，必填")
    @NotNull(message = "交易订单ID不能为空")
    private Long orderId;

    /**
     * 交易订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "交易订单编号，必填")
    @NotNull(message = "交易订单编号不能为空")
    private String orderNo;


    public Long getDeliveryOrderId() {
        return deliveryOrderId;
    }

    public void setDeliveryOrderId(Long deliveryOrderId) {
        this.deliveryOrderId = deliveryOrderId;
    }

    public List<PackageDto> getPackageDtos() {
        return packageDtos;
    }

    public void setPackageDtos(List<PackageDto> packageDtos) {
        this.packageDtos = packageDtos;
    }

    /**
     * 包裹列表
     */
    @ApiModelProperty(name = "packageDtos", value = "包裹列表，必填")
    @NotNull(message = "包裹列表不能为空")
    List<PackageDto> packageDtos;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID，必填")
    @NotNull(message = "实例ID不能为空")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，必填")
    @NotNull(message = "租户实例不能为空")
    private Long tenantId;

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}
