/*
 * @(#)InventoryException.java 1.0 2018-08-31
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 拆包配置查询Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "PackageSplitConfigQueryReqDto", description = "拆包配置查询Dto")
public class PackageSplitConfigQueryReqDto extends BaseVo {

    private Long id;

    /**
     * 应用实例ID
     */
    @NotNull(message = "实例Id不能为空")
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @NotNull(message = "租户ID不能为空")
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;

    /**
     * 分组id
     */
    @ApiModelProperty(name = "groupId", value = "分组id")
    private Long groupId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 设置应用实例ID
     */
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * 获取应用实例ID
     */
    public Long getInstanceId() {
        return this.instanceId;
    }

    /**
     * 设置编码
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取编码
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 设置名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取名称
     */
    public String getName() {
        return this.name;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}