/*
 * @(#)InventoryException.java 1.0 2018-09-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 运费模板和地区关联Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "RTtemplateAreaReqDto", description = "运费模板和地区关联Dto")
public class RTtemplateAreaReqDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "主键id  新增不需要传入")
    private Long id;

    /**
     * 运费模板id
     */
    @NotNull(message = "运费模板不能为空")
    @ApiModelProperty(name = "shippingTplId", value = "运费模板id 必填")
    private Long shippingTplId;

    /**
     * 省编码
     */
    @NotNull(message = "省编码不能为空")
    @ApiModelProperty(name = "provCode", value = "省编码 必填")
    private String provCode;

    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码 选填")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码 选填")
    private String areaCode;

    /**
     * 服务区编码
     */
    @NotNull(message = "服务区id不能为空")
    @ApiModelProperty(name = "serviceAreaId", value = "服务区编码 必填")
    private Long serviceAreaId;

    /**
     * 应用实例ID
     */
    @NotNull(message = "实例id不能为空")
    @ApiModelProperty(name = "instanceId", value = "应用实例ID 必填")
    private Long instanceId;

    /**
     * 租户ID
     */
    @NotNull(message = "租户ID不能为空")
    @ApiModelProperty(name = "tenantId", value = "租户ID 必填")
    private Long tenantId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setShippingTplId(Long shippingTplId) {
        this.shippingTplId = shippingTplId;
    }

    public Long getShippingTplId() {
        return this.shippingTplId;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public String getProvCode() {
        return this.provCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setServiceAreaId(Long serviceAreaId) {
        this.serviceAreaId = serviceAreaId;
    }

    public Long getServiceAreaId() {
        return this.serviceAreaId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}