/*
 * @(#)InventoryException.java 1.0 2018-09-03
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 物流公司请求Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ShippingCompanyQueryReqDto", description = "物流公司请求Dto")
public class ShippingCompanyUpdateReqDto extends BaseVo {


    /**
     * 应用实例ID
     */
    @NotNull(message = "实例ID不能为空")
    @ApiModelProperty(name = "instanceId", value = "应用实例ID 必填")
    private Long instanceId;

    /**
     * 租户ID
     */
    @NotNull(message = "租户ID不能为空")
    @ApiModelProperty(name = "tenantId", value = "租户ID 必填")
    private Long tenantId;

    /**
     * 物流公司名称
     */
    @ApiModelProperty(name = "name", value = "物流公司名称 选填")
    private String name;


    /**
     * 设置应用实例ID
     */
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * 获取应用实例ID
     */
    public Long getInstanceId() {
        return this.instanceId;
    }

    /**
     * 设置物流公司名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取物流公司名称
     */
    public String getName() {
        return this.name;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}