/*
 * @(#) ShippingPartnerCompanyReqDto.java 1.0 2018-12-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 渠道和物流公司关联关系表 ReqDto
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "ShippingPartnerCompanyReqDto", description = "渠道和物流公司关联关系表")
public class ShippingPartnerCompanyReqDto extends RequestDto {
    /**
     * ENABLED启用 DISABLED禁用 必填
     */
    @ApiModelProperty(name = "status", value = "ENABLED启用  DISABLED禁用  默认：ENABLED启用 ")
    private String status;
    /**
     * 物流渠道自己的物流编码
     */
    @ApiModelProperty(name = "partnerShippingCode", value = "物流渠道自己的物流编码 选填")
    private String partnerShippingCode;
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "shippingCode", value = "物流公司编码  必填")
    private String shippingCode;
    /**
     * 物流渠道编码
     */
    @ApiModelProperty(name = "partnerCode", value = "物流渠道编码 必填")
    private String partnerCode;
    /**
     * 物流公司id
     */
    @ApiModelProperty(name = "shippingCompanyId", value = "物流公司id 必填")
    private Long shippingCompanyId;
    /**
     * 物流渠道id
     */
    @ApiModelProperty(name = "shippingPartnerId", value = "物流渠道id 必填")
    private Long shippingPartnerId;
    /**
     * 拓展数据
     */
    @ApiModelProperty(name = "extension", value = "拓展数据 选填")
    private String extension;
    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID 必填")
    private Long instanceId;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPartnerShippingCode() {
        return this.partnerShippingCode;
    }

    public void setPartnerShippingCode(String partnerShippingCode) {
        this.partnerShippingCode = partnerShippingCode;
    }

    public String getShippingCode() {
        return this.shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public String getPartnerCode() {
        return this.partnerCode;
    }

    public void setPartnerCode(String partnerCode) {
        this.partnerCode = partnerCode;
    }

    public Long getShippingCompanyId() {
        return this.shippingCompanyId;
    }

    public void setShippingCompanyId(Long shippingCompanyId) {
        this.shippingCompanyId = shippingCompanyId;
    }

    public Long getShippingPartnerId() {
        return this.shippingPartnerId;
    }

    public void setShippingPartnerId(Long shippingPartnerId) {
        this.shippingPartnerId = shippingPartnerId;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }


}