/*
 * ShippingPartnerReqDto.class 1.0 2018-09-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 物流渠道请求Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
public class ShippingPartnerCreateReqDto extends BaseVo {
    /**
     * 渠道编码
     */
    @ApiModelProperty(name = "code", value = "渠道编码  必填")
    @NotNull(message = "渠道编码不能为空")
    private String code;

    /**
     * 渠道名称
     */
    @ApiModelProperty(name = "name", value = "渠道名称  必填")
    @NotNull(message = "渠道名称不能为空")
    private String name;
    /**
     * ENABLED启用 DISABLED禁用
     */
    @ApiModelProperty(name = "status", value = "ENABLED启用 DISABLED禁用  默认：ENABLED启用")
    private String status;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID 必填")
    @NotNull(message = "应用实例ID不能为空")
    private Long instanceId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID 必填")
    @NotNull(message = "租户实例不能为空")
    private Long tenantId;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

}
