/*
 * @(#)InventoryException.java 1.0 2018-09-07
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 运费规则查询Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ShippingRuleQueryReqDto", description = "运费规则查询Dto")
public class ShippingRuleQueryReqDto {

    /**
     * 基础费用
     */
    @ApiModelProperty(name = "baseCost", value = "基础费用")
    private BigDecimal baseCost;
    /**
     * 基础规格
     */
    @ApiModelProperty(name = "baseSpec", value = "基础规格")
    private BigDecimal baseSpec;
    /**
     * 超出费用
     */
    @ApiModelProperty(name = "incrCost", value = "超出费用")
    private BigDecimal incrCost;
    /**
     * 超出规格
     */
    @ApiModelProperty(name = "incrSpec", value = "超出规格")
    private BigDecimal incrSpec;

    public void setBaseCost(BigDecimal baseCost) {
        this.baseCost = baseCost;
    }

    public BigDecimal getBaseCost() {
        return this.baseCost;
    }

    public void setBaseSpec(BigDecimal baseSpec) {
        this.baseSpec = baseSpec;
    }

    public BigDecimal getBaseSpec() {
        return this.baseSpec;
    }

    public void setIncrCost(BigDecimal incrCost) {
        this.incrCost = incrCost;
    }

    public BigDecimal getIncrCost() {
        return this.incrCost;
    }

    public void setIncrSpec(BigDecimal incrSpec) {
        this.incrSpec = incrSpec;
    }

    public BigDecimal getIncrSpec() {
        return this.incrSpec;
    }

}