/*
 * @(#)InventoryException.java 1.0 2018-09-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 运费模板请求Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ShippingTemplateQueryReqDto", description = "运费模板请求Dto")
public class ShippingTemplateQueryReqDto extends BaseVo {

    private Long id;
    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;

    /**
     * CUSTOMER 面向顾客 OPERATER
     */
    @ApiModelProperty(name = "type", value = "模板类型")
    private String type;

    /**
     * BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量
     */
    @ApiModelProperty(name = "computeMode", value = "BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量")
    private String computeMode;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;

    /**
     * 应用实例ID
     */
    @NotNull(message = "实例id不能为空")
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @NotNull(message = "租户ID不能为空")
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    /**
     * 运费规格Dto
     */
    @ApiModelProperty(name = "shippingRuleQueryReqDto", value = "运费规格查询Dto")
    private ShippingRuleQueryReqDto shippingRuleQueryReqDto;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getComputeMode() {
        return computeMode;
    }

    public void setComputeMode(String computeMode) {
        this.computeMode = computeMode;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public ShippingRuleQueryReqDto getShippingRuleQueryReqDto() {
        return shippingRuleQueryReqDto;
    }

    public void setShippingRuleQueryReqDto(ShippingRuleQueryReqDto shippingRuleQueryReqDto) {
        this.shippingRuleQueryReqDto = shippingRuleQueryReqDto;
    }
}