/*
 * @(#)InventoryException.java 1.0 2018-09-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 运费模板修改Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ShippingTemplateUpdateReqDto", description = "运费模板修改Dto")
public class ShippingTemplateUpdateReqDto extends BaseVo {


    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "名称 选填")
    private String name;

    /**
     * CUSTOMER 面向顾客 OPERATER
     */
    @ApiModelProperty(name = "type", value = "模板类型：CUSTOMER 面向顾客 OPERATER  选填")
    private String type;

    /**
     * BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量
     */
    @ApiModelProperty(name = "computeMode", value = "BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量  选填")
    private String computeMode;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID  选填")
    private Long groupId;

    /**
     * 应用实例ID
     */
    @NotNull(message = "实例id不能为空")
    @ApiModelProperty(name = "instanceId", value = "应用实例ID 必填")
    private Long instanceId;

    /**
     * 租户ID
     */
    @NotNull(message = "租户ID不能为空")
    @ApiModelProperty(name = "tenantId", value = "租户ID  必填")
    private Long tenantId;

    /**
     * 运费规格Dto
     */
    @ApiModelProperty(name = "shippingRuleUpdateReqDto", value = "运费规格修改Dto  选填")
    private ShippingRuleUpdateReqDto shippingRuleUpdateReqDto;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getComputeMode() {
        return computeMode;
    }

    public void setComputeMode(String computeMode) {
        this.computeMode = computeMode;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public ShippingRuleUpdateReqDto getShippingRuleUpdateReqDto() {
        return shippingRuleUpdateReqDto;
    }

    public void setShippingRuleUpdateReqDto(ShippingRuleUpdateReqDto shippingRuleUpdateReqDto) {
        this.shippingRuleUpdateReqDto = shippingRuleUpdateReqDto;
    }
}