/*
 * @(#)InventoryException.java 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 面向经营者的运费计算结果Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "FreightForOperatorRespDto", description = "面向经营者的运费计算结果Dto")
public class FreightForOperatorRespDto extends BaseVo {

    /**
     * 计价方式
     */
    @ApiModelProperty(name = "computeMode", value = "计价方式")
    private String computeMode;

    /**
     * 运费
     */
    @ApiModelProperty(name = "freight", value = "运费")
    private BigDecimal freight;

    /**
     * 总规格
     */
    @ApiModelProperty(name = "spec", value = "总规格")
    private BigDecimal spec;

    public String getComputeMode() {
        return computeMode;
    }

    public void setComputeMode(String computeMode) {
        this.computeMode = computeMode;
    }

    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public BigDecimal getSpec() {
        return spec;
    }

    public void setSpec(BigDecimal spec) {
        this.spec = spec;
    }
}