/*
 * PackageRespDto.class 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 包裹响应Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "PackageRespDto", description = "包裹响应Dto")
public class PackageRespDto extends BaseVo {
    /**
     * 发货单ID
     */
    @ApiModelProperty(name = "deliveryOrderId", value = "发货单ID")
    private Long deliveryOrderId;

    public Long getDeliveryOrderId() {
        return deliveryOrderId;
    }

    public void setDeliveryOrderId(Long deliveryOrderId) {
        this.deliveryOrderId = deliveryOrderId;
    }

    public List<PackageDto> getPackageDtos() {
        return packageDtos;
    }

    public void setPackageDtos(List<PackageDto> packageDtos) {
        this.packageDtos = packageDtos;
    }

    /**
     * 包裹列表
     */
    @ApiModelProperty(name = "packageDtos", value = "包裹列表")
    List<PackageDto> packageDtos;
}
