/*
 * PackageRespDto.class 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import com.dtyunxi.cube.commons.channel.shipping.beans.Trace;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 包裹物流信息响应Dto
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "PackageShippingLogRespDto", description = "包裹物流信息响应Dto")
public class PackageShippingLogRespDto extends BaseVo {
    /**
     * 包裹信息
     */
    @ApiModelProperty(name = "pack", value = "包裹信息")
    PackageDto pack;
    /**
     * 物流信息
     */
    @ApiModelProperty(name = "traces", value = "物流信息")
    List<Trace> traces;
    /**
     * 查询方式 1 是数据库 2 是渠道查询
     */
    @ApiModelProperty(name = "type", value = "查询方式 1 是数据库 2 是渠道查询")
    Integer type;

    public PackageDto getPack() {
        return pack;
    }

    public void setPack(PackageDto pack) {
        this.pack = pack;
    }

    public List<Trace> getTraces() {
        return traces;
    }

    public void setTraces(List<Trace> traces) {
        this.traces = traces;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
