/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 仓库和服务区关联响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "RAreaWarehouseRespDto", description = "仓库和服务区关联响应Dto")
public class RAreaWarehouseRespDto extends BaseVo {

    private Long id;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    /**
     * 服务器ID
     */
    @ApiModelProperty(name = "serviceAreaId", value = "服务器ID")
    private Long serviceAreaId;

    /**
     * 设置主键ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 获取主键ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 设置实例ID
     */
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * 获取实例ID
     */
    public Long getInstanceId() {
        return this.instanceId;
    }

    /**
     * 设置仓库ID
     */
    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    /**
     * 获取仓库ID
     */
    public Long getWarehouseId() {
        return this.warehouseId;
    }

    /**
     * 设置服务器ID
     */
    public void setServiceAreaId(Long serviceAreaId) {
        this.serviceAreaId = serviceAreaId;
    }

    /**
     * 获取服务器ID
     */
    public Long getServiceAreaId() {
        return this.serviceAreaId;
    }
}