/*
 * @(#) ShippingPartnerCompanyRespDto.java 1.0 2018-12-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 渠道和物流公司关联关系表 RespDto
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "ShippingPartnerCompanyRepDto", description = "渠道和物流公司关联关系表")
public class ShippingPartnerCompanyDetailRespDto extends BaseVo {
    /**
     * ENABLED启用 DISABLED禁用
     */
    @ApiModelProperty(name = "status", value = "ENABLED启用DISABLED禁用")
    private String status;
    /**
     * 物流渠道自己的物流编码
     */
    @ApiModelProperty(name = "partnerShippingCode", value = "物流渠道自己的物流编码")
    private String partnerShippingCode;
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "shippingCode", value = "物流公司编码")
    private String shippingCode;
    /**
     * 物流渠道编码
     */
    @ApiModelProperty(name = "partnerCode", value = "物流渠道编码")
    private String partnerCode;
    /**
     * 物流公司id
     */
    @ApiModelProperty(name = "shippingCompanyId", value = "物流公司id")
    private Long shippingCompanyId;
    /**
     * 物流渠道id
     */
    @ApiModelProperty(name = "shippingPartnerId", value = "物流渠道id")
    private Long shippingPartnerId;

    /**
     * 拓展数据
     */
    @ApiModelProperty(name = "extension", value = "拓展数据")
    private String extension;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;
    @ApiModelProperty(name = "shippingPartnerRespDto", value = "物流渠道信息")
    private ShippingPartnerRespDto shippingPartnerRespDto;

    public ShippingPartnerRespDto getShippingPartnerRespDto() {
        return shippingPartnerRespDto;
    }

    public void setShippingPartnerRespDto(ShippingPartnerRespDto shippingPartnerRespDto) {
        this.shippingPartnerRespDto = shippingPartnerRespDto;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPartnerShippingCode() {
        return this.partnerShippingCode;
    }

    public void setPartnerShippingCode(String partnerShippingCode) {
        this.partnerShippingCode = partnerShippingCode;
    }

    public String getShippingCode() {
        return this.shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public String getPartnerCode() {
        return this.partnerCode;
    }

    public void setPartnerCode(String partnerCode) {
        this.partnerCode = partnerCode;
    }

    public Long getShippingCompanyId() {
        return this.shippingCompanyId;
    }

    public void setShippingCompanyId(Long shippingCompanyId) {
        this.shippingCompanyId = shippingCompanyId;
    }

    public Long getShippingPartnerId() {
        return this.shippingPartnerId;
    }

    public void setShippingPartnerId(Long shippingPartnerId) {
        this.shippingPartnerId = shippingPartnerId;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }


}