/*
 * ShippingPartnerRespDto.class 1.0 2018-09-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 物流渠道响应Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "ShippingPartnerRespDto", description = "物流渠道响应Dto")
public class ShippingPartnerRespDto extends BaseVo {
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 渠道编码
     */
    @ApiModelProperty(name = "code", value = "渠道编码")
    private String code;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    /**
     * 渠道名称
     */
    @ApiModelProperty(name = "name", value = "渠道名称")
    private String name;
    /**
     * ENABLED启用 DISABLED禁用
     */
    @ApiModelProperty(name = "status", value = "ENABLED启用 DISABLED禁用")
    private String status;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
}
