/*
 * @(#)InventoryException.java 1.0 2018-09-07
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 运费规格响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ShippingRuleRespDto", description = "运费规格响应Dto")
public class ShippingRuleRespDto {

    /**
     * 基础费用
     */
    @ApiModelProperty(name = "baseCost", value = "基础费用")
    private BigDecimal baseCost;
    /**
     * 基础规格
     */
    @ApiModelProperty(name = "baseSpec", value = "基础规格")
    private BigDecimal baseSpec;
    /**
     * 超出费用
     */
    @ApiModelProperty(name = "incrCost", value = "超出费用")
    private BigDecimal incrCost;
    /**
     * 超出规格
     */
    @ApiModelProperty(name = "incrSpec", value = "超出规格")
    private BigDecimal incrSpec;

    public BigDecimal getBaseCost() {
        return baseCost;
    }

    public void setBaseCost(BigDecimal baseCost) {
        this.baseCost = baseCost;
    }

    public BigDecimal getBaseSpec() {
        return baseSpec;
    }

    public void setBaseSpec(BigDecimal baseSpec) {
        this.baseSpec = baseSpec;
    }

    public BigDecimal getIncrCost() {
        return incrCost;
    }

    public void setIncrCost(BigDecimal incrCost) {
        this.incrCost = incrCost;
    }

    public BigDecimal getIncrSpec() {
        return incrSpec;
    }

    public void setIncrSpec(BigDecimal incrSpec) {
        this.incrSpec = incrSpec;
    }
}