/*
 * @(#)InventoryException.java 1.0 2018-09-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 运费模板响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ShippingTemplateRespDto", description = "运费模板响应Dto")
public class ShippingTemplateRespDto extends BaseVo {

    /**
     * 运费模板id
     */
    @ApiModelProperty(name = "id", value = "运费模板id")
    private Long id;

    /**
     * 运费模板编码
     */
    @ApiModelProperty(name = "code", value = "运费模板编码")
    private String code;

    /**
     * 运费模板名称
     */
    @ApiModelProperty(name = "name", value = "运费模板名称")
    private String name;

    /**
     * 类型： CUSTOMER 面向顾客 OPERATER
     */
    @ApiModelProperty(name = "type", value = "类型  CUSTOMER 面向顾客 OPERATER")
    private String type;

    /**
     * 分组id
     */
    @ApiModelProperty(name = "groupId", value = "分组id")
    private Long groupId;

    /**
     * 计价方式
     * BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量 BY_ORDER按订单
     */
    @ApiModelProperty(name = "computeMode", value = "计价方式 BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量 BY_ORDER按订单")
    private String computeMode;

    /**
     * 基础费用
     */
    @ApiModelProperty(name = "baseCost", value = "基础费用")
    private BigDecimal baseCost;

    /**
     * 基础规格
     */
    @ApiModelProperty(name = "baseSpec", value = "基础规格")
    private BigDecimal baseSpec;

    /**
     * 超出费用
     */
    @ApiModelProperty(name = "incrCost", value = "超出费用")
    private BigDecimal incrCost;

    /**
     * 超出规格
     */
    @ApiModelProperty(name = "incrSpec", value = "超出规格")
    private BigDecimal incrSpec;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getComputeMode() {
        return computeMode;
    }

    public void setComputeMode(String computeMode) {
        this.computeMode = computeMode;
    }

    public BigDecimal getBaseCost() {
        return baseCost;
    }

    public void setBaseCost(BigDecimal baseCost) {
        this.baseCost = baseCost;
    }

    public BigDecimal getBaseSpec() {
        return baseSpec;
    }

    public void setBaseSpec(BigDecimal baseSpec) {
        this.baseSpec = baseSpec;
    }

    public BigDecimal getIncrCost() {
        return incrCost;
    }

    public void setIncrCost(BigDecimal incrCost) {
        this.incrCost = incrCost;
    }

    public BigDecimal getIncrSpec() {
        return incrSpec;
    }

    public void setIncrSpec(BigDecimal incrSpec) {
        this.incrSpec = incrSpec;
    }
}