/*
 * @(#)InventoryException.java 1.0 2018-09-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForCustomerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForOperatorRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 运费查询Api
 *
 * @author 佐助
 * @since 2.0.0
 */
@Api(tags = {"库存中心：运费查询服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/freight")
public interface IFreightQueryApi {

    /**
     * 消费端：根据订单列表查询运费
     *
     * @param filter 业务参数封装对象JSON
     * @return FreightForCustomerRespDto集合 订单运费列表
     */
    @GetMapping(value = "/customer", produces = "application/json")
    @ApiOperation(value = "消费端：根据订单列表查询运费", notes = "消费端：根据订单列表查询运费 \t\n filter=FreightForOrderReqDto" +
            " \t\n filter:业务参数封装对象JSON" +
            "\t\n JSON格式如下：\t\n" +
            "{\n" +
            "\"orderDetailReqDtos\":[{\n" +
            "\"orderId\":\"Long:订单id:必填\",\n" +
            "\"cargoDetailReqDtos\":[{\n" +
            "\"cargoId\":\"Long:货品id:必填:\",\n" +
            "\"shippingTplId\":\"运费模版id:必填:\",\n" +
            "\"num\":\"Long:货品数量:必填\",\n" +
            "\"quantity\":\"重量：必填\",\n" +
            "\"volume\":\"体积：必填\"\n" +
            "}]\n" +
            "}],\n" +
            "\"instanceId\":\"Long:实例id:必填\",\n" +
            "\"tenantId\":\"Long:租户id:必填\"\n" +
            "}")
    RestResponse<List<FreightForCustomerRespDto>> queryByCustomer(@NotBlank(message = "订单列表不能为空") @RequestParam("filter") String filter);

    /**
     * 管理端：根据货品列表查询运费
     *
     * @param filter 业务参数封装对象JSON
     * @return FreightForOperatorRespDto 货品运费
     */
    @GetMapping(value = "/operator", produces = "application/json")
    @ApiOperation(value = "管理端：根据货品列表查询运费", notes = "管理端：根据货品列表查询运费 \t\n filter=FreightForCargoReqDto" +
            "\t\n filter:业务参数封装对象JSON" +
            "\t\n JSON格式如下：\t\n" +
            "{\n" +
            "\"cargoDetailReqDtos\":[{\n" +
            "\"cargoId\":\"Long:货品id:必填:\",\n" +
            "\"num\":\"Long:货品数量:必填\"\n" +
            "\"shippingTplId\":\"运费模版id:必填:\",\n" +
            "\"quantity\":\"重量：必填\",\n" +
            "\"volume\":\"体积：必填\"\n" +
            "}],\n" +
            "\"instanceId\":\"Long:实例id:必填\",\n" +
            "\"tenantId\":\"Long:租户id:必填\"\n" +
            "}")
    RestResponse<FreightForOperatorRespDto> queryByOperator(@NotBlank(message = "订单列表不能为空") @RequestParam("filter") String filter);


}