/*
 * @(#)IShippingPartnerCompanyQueryApi.java 1.0 2018-12-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shipping.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerCompanyRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 渠道和物流公司关联关系表 查询api
 *
 * @author 简树
 * @since 2.0.0
 */

@Api(tags = {"库存中心:"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v1/ShippingPartnerCompany")
public interface IShippingPartnerCompanyQueryApi {
    /**
     * 根据ID查询渠道和物流公司关联关系表
     *
     * @param id 渠道和物流公司关联关系表ID
     * @return StorageOrderCombineRespDto 渠道和物流公司关联关系表
     */
    @GetMapping(value = "/check/{id}", produces = "application/json")
    @ApiOperation(value = "根据ID渠道和物流公司关联关系表", notes = "根据ID渠道和物流公司关联关系表")
    RestResponse<ShippingPartnerCompanyRespDto> queryById(@PathVariable("id") Long id, @RequestParam(value = "instanceId") Long instanceId,
                                                          @RequestParam(value = "tenantId") Long tenantId);

    /**
     * 分页渠道和物流公司关联关系表
     *
     * @param filter   查询条件，json字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return ShippingPartnerCompanyRespDto 分页渠道和物流公司关联关系表Dto分页列表
     */
    @GetMapping(value = "/check", produces = "application/json")
    @ApiOperation(value = "分页查询渠道和物流公司关联关系表", notes = "分页查询渠道和物流公司关联关系表")
    RestResponse<PageInfo<ShippingPartnerCompanyRespDto>> queryByPage(@RequestParam(name = "filter") String filter,
                                                                      @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}