/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.ITransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.TcbjStockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageCheckRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ITransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderDetailEo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="transferOrderApi")
public class TransferOrderApiImpl
implements ITransferOrderApi {
    @Resource
    private ITransferOrderService transferOrderService;

    public RestResponse<Long> addTransferOrder(TransferOrderAddReqDto reqDto) {
        return new RestResponse((Object)this.transferOrderService.addTransferOrder(reqDto));
    }

    public RestResponse<Void> modifyTransferOrder(TransferOrderModifyReqDto reqDto) {
        this.transferOrderService.modifyTransferOrder(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeTransferOrder(String ids) {
        this.transferOrderService.removeTransferOrder(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> cancelTransferOrder(TransferOrderCancelReqDto reqDto) {
        this.transferOrderService.cancelTransferOrder(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<List<StorageCheckRespDto>> auditTransferOrder(TransferOrderAuditReqDto reqDto) {
        return new RestResponse(this.transferOrderService.auditTransferOrder(reqDto));
    }

    public RestResponse<Void> tcbjPhysicLogicWarehouseOut(TcbjStockChangeDto reqDto) {
        List detailEos = reqDto.getDetailEos();
        List<StorageOrderDetailEo> collect = detailEos.stream().map(e -> {
            StorageOrderDetailEo storageOrderDetailEo = new StorageOrderDetailEo();
            BeanUtils.copyProperties((Object)e, (Object)storageOrderDetailEo);
            return storageOrderDetailEo;
        }).collect(Collectors.toList());
        this.transferOrderService.tcbjPhysicLogicWarehouseOut(reqDto.getStockChangeOut(), collect);
        return RestResponse.VOID;
    }
}

