/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventoryCountDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.PositionCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.PositionUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RAreaWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ServiceAreaCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ServiceAreaUpdateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseLockReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseUnLockReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IElectricFenceService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IPositionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRAreaWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRServiceAreaService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IServiceAreaService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ElectricFenceDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RAreaWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ElectricFenceEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RAreaWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RServiceAreaEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ServiceAreaEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="warehouseApi")
public class WarehouseApiImpl
implements IWarehouseApi {
    @Resource
    private IWarehouseService wareHouseService;
    @Resource
    private IRAreaWarehouseService irAreaWarehouseService;
    @Resource
    private IPositionService positionService;
    @Resource
    private IServiceAreaService serviceAreaService;
    @Resource
    private IRAreaWarehouseService areaWarehouseService;
    @Resource
    private IElectricFenceService electricFenceService;
    @Resource
    private IRServiceAreaService irServiceAreaService;
    @Resource
    private RAreaWarehouseDas rAreaWarehouseDas;
    @Resource
    private ServiceAreaDas serviceAreaDas;
    @Resource
    private RServiceAreaDas rServiceAreaDas;
    @Resource
    private ElectricFenceDas electricFenceDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private RefWarehouseDas refWarehouseDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private WarehouseDeliveryDas warehouseDeliveryDas;
    @Resource
    private ICommonsMqService commonsMqService;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addWarehouse(WarehouseCreateReqDto warehouseCreateReqDto) {
        if (warehouseCreateReqDto == null) {
            throw new BizException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
        }
        WarehouseEo warehouseEoParam = new WarehouseEo();
        warehouseEoParam.setCode(warehouseCreateReqDto.getCode());
        int count = this.warehouseDas.count((BaseEo)warehouseEoParam);
        if (count > 0) {
            return new RestResponse(InventoryExceptionCode.WAREHOUSE_CODE_EXIST.getCode(), InventoryExceptionCode.WAREHOUSE_CODE_EXIST.getMsg());
        }
        Boolean expressDeliveryStatus = warehouseCreateReqDto.getExpressDeliveryStatus();
        List areaDtoList = warehouseCreateReqDto.getServiceAreaList();
        if (expressDeliveryStatus != null && expressDeliveryStatus.booleanValue() && CollectionUtils.isEmpty((Collection)areaDtoList)) {
            throw new BizException(InventoryExceptionCode.WAREHOUSE_EXPRESS_DELIVER_AREA_NULL_ERROR.getCode(), InventoryExceptionCode.WAREHOUSE_EXPRESS_DELIVER_AREA_NULL_ERROR.getMsg());
        }
        Boolean cityDeliveryStatus = warehouseCreateReqDto.getCityDeliveryStatus();
        String geoFence = warehouseCreateReqDto.getGeoFence();
        if (cityDeliveryStatus != null && cityDeliveryStatus.booleanValue() && StringUtils.isBlank((CharSequence)geoFence)) {
            throw new BizException(InventoryExceptionCode.WAREHOUSE_CITY_DELIVERY_GEO_FENCE_NULL_ERROR.getCode(), InventoryExceptionCode.WAREHOUSE_CITY_DELIVERY_GEO_FENCE_NULL_ERROR.getMsg());
        }
        if (null != warehouseCreateReqDto.getParentId()) {
            WarehouseEo warehouseParent = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(warehouseCreateReqDto.getParentId());
            warehouseCreateReqDto.setDeliverThresholdValue(warehouseParent.getDeliverThresholdValue());
        }
        WarehouseEo warehouseEo = new WarehouseEo();
        DtoHelper.dto2Eo((BaseVo)warehouseCreateReqDto, (BaseEo)warehouseEo);
        if (!CollectionUtils.isEmpty((Collection)warehouseCreateReqDto.getWarehouseDeliveryDtoList())) {
            warehouseEo.setExtension(JSON.toJSONString((Object)warehouseCreateReqDto.getWarehouseDeliveryDtoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)warehouseCreateReqDto.getCoordinates())) {
            String[] arr = StringUtils.split((String)warehouseCreateReqDto.getCoordinates(), (String)",");
            warehouseEo.setLongitude(NumberUtils.createBigDecimal((String)arr[0]));
            warehouseEo.setLatitude(NumberUtils.createBigDecimal((String)arr[1]));
        }
        warehouseEo.setCreditValue(Integer.valueOf(100));
        warehouseEo.setDeliverTimeLimit(Integer.valueOf(0));
        warehouseEo.setThresholdValue(Integer.valueOf(100));
        warehouseEo.setContinueRejectOrder(Integer.valueOf(0));
        warehouseEo.setDeliverThresholdLeftValue(warehouseCreateReqDto.getDeliverThresholdValue());
        Long warehousesId = this.wareHouseService.addWarehouse(warehouseEo);
        Long groupId = warehouseCreateReqDto.getGroupId();
        Long tenantId = warehouseCreateReqDto.getTenantId();
        Long instanceId = warehouseCreateReqDto.getInstanceId();
        if (!CollectionUtils.isEmpty((Collection)areaDtoList)) {
            ServiceAreaEo serviceAreaEo = new ServiceAreaEo();
            serviceAreaEo.setCode(warehouseEo.getCode());
            serviceAreaEo.setName(warehouseEo.getName());
            serviceAreaEo.setTenantId(tenantId);
            serviceAreaEo.setInstanceId(instanceId);
            serviceAreaEo.setGroupId(groupId);
            this.serviceAreaDas.insert((BaseEo)serviceAreaEo);
            Long serviceAreaId = serviceAreaEo.getId();
            if (serviceAreaId != null) {
                RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
                rAreaWarehouseEo.setGroupId(groupId);
                rAreaWarehouseEo.setWarehouseId(warehousesId);
                rAreaWarehouseEo.setServiceAreaId(serviceAreaId);
                rAreaWarehouseEo.setTenantId(tenantId);
                rAreaWarehouseEo.setInstanceId(instanceId);
                rAreaWarehouseEo.setGroupId(groupId);
                this.rAreaWarehouseDas.insert((BaseEo)rAreaWarehouseEo);
                Long areaWarehouseId = rAreaWarehouseEo.getId();
                if (areaWarehouseId != null) {
                    ArrayList rServiceAreaEoList = Lists.newArrayListWithCapacity((int)areaDtoList.size());
                    DtoHelper.dtoList2EoList((Collection)areaDtoList, (Collection)rServiceAreaEoList, RServiceAreaEo.class);
                    rServiceAreaEoList.forEach(eo -> {
                        eo.setServiceAreaId(serviceAreaId);
                        eo.setInstanceId(instanceId);
                        eo.setTenantId(tenantId);
                        eo.setGroupId(groupId);
                    });
                    this.rServiceAreaDas.insertBatch((List)rServiceAreaEoList);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)warehouseCreateReqDto.getGeoFence())) {
            ElectricFenceEo electricFenceEo = new ElectricFenceEo();
            electricFenceEo.setWarehouseId(warehousesId);
            electricFenceEo.setParamsValue(geoFence);
            electricFenceEo.setInstanceId(instanceId);
            electricFenceEo.setTenantId(tenantId);
            this.electricFenceService.addElectricFence(electricFenceEo);
        }
        return RestResponse.createLong((Long)warehousesId);
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyWarehouse(Long id, WarehouseUpdateReqDto warehouseUpdateReqDto) {
        WarehouseEo warehouseEo = new WarehouseEo();
        if (null != warehouseUpdateReqDto) {
            DtoHelper.dto2Eo((BaseVo)warehouseUpdateReqDto, (BaseEo)warehouseEo, (String[])new String[]{"instanceId", "tenantId"});
            if (StringUtils.isNotBlank((CharSequence)warehouseUpdateReqDto.getCoordinates())) {
                String[] arr = StringUtils.split((String)warehouseUpdateReqDto.getCoordinates(), (String)",");
                warehouseEo.setLongitude(NumberUtils.createBigDecimal((String)arr[0]));
                warehouseEo.setLatitude(NumberUtils.createBigDecimal((String)arr[1]));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)warehouseUpdateReqDto.getWarehouseDeliveryDtoList())) {
            warehouseEo.setExtension(JSON.toJSONString((Object)warehouseUpdateReqDto.getWarehouseDeliveryDtoList()));
        }
        warehouseEo.setId(id);
        if (StringUtils.isNotEmpty((CharSequence)warehouseEo.getStatus()) && !"NORMAL".equals(warehouseEo.getStatus())) {
            Assert.isTrue(CollectionUtils.isEmpty((Collection)this.refWarehouseDas.selectPage(SqlFilterBuilder.create(RefWarehouseEo.class).eq("ref_warehouse_id", (Object)id).eo(), Integer.valueOf(1), Integer.valueOf(1)).getList()), "\u5df2\u5173\u8054\u7684\u4ed3\u5e93\u4e0d\u5141\u8bb8\u7981\u7528");
        }
        this.wareHouseService.modifyWarehouse(warehouseEo);
        if (warehouseUpdateReqDto != null) {
            Boolean expressDeliveryStatus = warehouseUpdateReqDto.getExpressDeliveryStatus();
            List areaDtoList = warehouseUpdateReqDto.getServiceAreaList();
            if (expressDeliveryStatus != null && expressDeliveryStatus.booleanValue() && CollectionUtils.isEmpty((Collection)areaDtoList)) {
                throw new BizException(InventoryExceptionCode.WAREHOUSE_EXPRESS_DELIVER_AREA_NULL_ERROR.getCode(), InventoryExceptionCode.WAREHOUSE_EXPRESS_DELIVER_AREA_NULL_ERROR.getMsg());
            }
            Boolean cityDeliveryStatus = warehouseUpdateReqDto.getCityDeliveryStatus();
            String geoFence = warehouseUpdateReqDto.getGeoFence();
            if (cityDeliveryStatus != null && cityDeliveryStatus.booleanValue() && StringUtils.isBlank((CharSequence)geoFence)) {
                throw new BizException(InventoryExceptionCode.WAREHOUSE_CITY_DELIVERY_GEO_FENCE_NULL_ERROR.getCode(), InventoryExceptionCode.WAREHOUSE_CITY_DELIVERY_GEO_FENCE_NULL_ERROR.getMsg());
            }
            Long tenantId = warehouseUpdateReqDto.getTenantId();
            Long instanceId = warehouseUpdateReqDto.getInstanceId();
            Long groupId = warehouseUpdateReqDto.getGroupId();
            RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
            rAreaWarehouseEo.setWarehouseId(id);
            RAreaWarehouseEo rAreaWarehouse = (RAreaWarehouseEo)this.rAreaWarehouseDas.selectOne((BaseEo)rAreaWarehouseEo);
            Long serviceAreaId = null;
            if (rAreaWarehouse != null) {
                serviceAreaId = rAreaWarehouse.getServiceAreaId();
                RServiceAreaEo rServiceAreaEo = new RServiceAreaEo();
                rServiceAreaEo.setServiceAreaId(serviceAreaId);
                this.rServiceAreaDas.logicDelete((BaseEo)rServiceAreaEo);
            } else {
                ServiceAreaEo serviceAreaEoParam = new ServiceAreaEo();
                serviceAreaEoParam.setCode(warehouseEo.getCode());
                List serviceAreaEoList = this.serviceAreaDas.select((BaseEo)serviceAreaEoParam);
                if (!CollectionUtils.isEmpty((Collection)serviceAreaEoList)) {
                    serviceAreaId = ((ServiceAreaEo)serviceAreaEoList.get(0)).getId();
                } else {
                    ServiceAreaEo serviceAreaEo = new ServiceAreaEo();
                    serviceAreaEo.setCode(warehouseEo.getCode());
                    serviceAreaEo.setName(warehouseEo.getName());
                    serviceAreaEo.setTenantId(tenantId);
                    serviceAreaEo.setInstanceId(instanceId);
                    serviceAreaEo.setGroupId(groupId);
                    this.serviceAreaDas.insert((BaseEo)serviceAreaEo);
                    serviceAreaId = serviceAreaEo.getId();
                }
                RAreaWarehouseEo addAreaWarehouseEo = new RAreaWarehouseEo();
                addAreaWarehouseEo.setGroupId(groupId);
                addAreaWarehouseEo.setWarehouseId(id);
                addAreaWarehouseEo.setServiceAreaId(serviceAreaId);
                addAreaWarehouseEo.setTenantId(tenantId);
                addAreaWarehouseEo.setInstanceId(instanceId);
                addAreaWarehouseEo.setGroupId(groupId);
                this.rAreaWarehouseDas.insert((BaseEo)addAreaWarehouseEo);
            }
            if (serviceAreaId != null && !CollectionUtils.isEmpty((Collection)areaDtoList)) {
                ArrayList rServiceAreaEoList = Lists.newArrayListWithCapacity((int)areaDtoList.size());
                DtoHelper.dtoList2EoList((Collection)areaDtoList, (Collection)rServiceAreaEoList, RServiceAreaEo.class);
                Long finalServiceAreaId = serviceAreaId;
                rServiceAreaEoList.forEach(eo -> {
                    eo.setServiceAreaId(finalServiceAreaId);
                    eo.setInstanceId(instanceId);
                    eo.setTenantId(tenantId);
                    eo.setGroupId(groupId);
                });
                this.rServiceAreaDas.insertBatch((List)rServiceAreaEoList);
            }
            String geofence = warehouseUpdateReqDto.getGeoFence();
            ElectricFenceEo electricFenceEo = new ElectricFenceEo();
            electricFenceEo.setWarehouseId(id);
            ElectricFenceEo electricFence = (ElectricFenceEo)this.electricFenceDas.selectOne((BaseEo)electricFenceEo);
            if (electricFence != null) {
                this.electricFenceDas.logicDeleteById(electricFence.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)geofence)) {
                electricFenceEo.setWarehouseId(id);
                electricFenceEo.setParamsValue(geofence);
                electricFenceEo.setTenantId(tenantId);
                electricFenceEo.setInstanceId(instanceId);
                this.electricFenceService.addElectricFence(electricFenceEo);
            }
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeWarehouseByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.wareHouseService.removeByCode(code);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeWarehouseById(@NotNull(message="\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.wareHouseService.removeById(id);
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        rAreaWarehouseEo.setWarehouseId(id);
        this.rAreaWarehouseDas.logicDelete((BaseEo)rAreaWarehouseEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeWarehouseByServiceAreaId(Long serviceAreaId, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.wareHouseService.removeByServiceAreaId(serviceAreaId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeWarehouseByIds(String ids, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        if (StringUtils.isEmpty((CharSequence)ids)) {
            InventoryBusinessRuntimeException.parameterError();
        }
        String[] id = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String i : id) {
            idList.add(Long.valueOf(i));
        }
        this.wareHouseService.removeByIds(idList);
        return RestResponse.VOID;
    }

    public RestResponse<Long> relateToServiceArea(RAreaWarehouseReqDto rAreaWarehouseReqDto) {
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        if (null != rAreaWarehouseReqDto) {
            DtoHelper.dto2Eo((BaseVo)rAreaWarehouseReqDto, (BaseEo)rAreaWarehouseEo);
        }
        return new RestResponse((Object)this.irAreaWarehouseService.addRAreaWarehouse(rAreaWarehouseEo));
    }

    public RestResponse<Void> removeRelation(String ids, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        if (StringUtils.isEmpty((CharSequence)ids)) {
            InventoryBusinessRuntimeException.parameterError();
        }
        String[] id = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String i : id) {
            idList.add(Long.valueOf(i));
        }
        this.irAreaWarehouseService.removeByIds(idList, requestDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addPosition(PositionCreateReqDto positionCreateReqDto) {
        return new RestResponse((Object)this.positionService.addPosition(positionCreateReqDto));
    }

    public RestResponse<Void> modifyPosition(Long id, PositionUpdateReqDto positionUpdateReqDto) {
        this.positionService.modifyPosition(id, positionUpdateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removePositionById(Long id, String filter) {
        this.positionService.removeById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removePositionByCode(String code, String filter) {
        this.positionService.removeByCode(code);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyServiceArea(Long id, ServiceAreaUpdateDto serviceAreaUpdateDto) {
        ServiceAreaEo serviceAreaEo = new ServiceAreaEo();
        DtoHelper.dto2Eo((BaseVo)serviceAreaUpdateDto, (BaseEo)serviceAreaEo);
        serviceAreaEo.setId(id);
        this.serviceAreaService.modifyServiceArea(serviceAreaEo);
        return RestResponse.VOID;
    }

    public RestResponse removeServiceAreaById(Long id, String filter) {
        this.serviceAreaService.removeById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addServiceArea(ServiceAreaCreateDto serviceAreaCreateDto) {
        ServiceAreaEo serviceAreaEo = new ServiceAreaEo();
        if (null != serviceAreaCreateDto) {
            DtoHelper.dto2Eo((BaseVo)serviceAreaCreateDto, (BaseEo)serviceAreaEo);
        }
        this.serviceAreaService.addServiceArea(serviceAreaEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> switchInventoryShareStatus(Long id, Integer status) {
        WarehouseEo eo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(id);
        if (eo == null) {
            return new RestResponse(InventoryExceptionCode.WAREHOUSE_INFO_NOT_EXISTS.getCode(), InventoryExceptionCode.WAREHOUSE_INFO_NOT_EXISTS.getMsg());
        }
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setId(id);
        warehouseEo.setInventoryShareStatus(Boolean.valueOf(status == 1));
        this.warehouseDas.updateSelective((BaseEo)warehouseEo);
        List cargoStorageEos = this.cargoStorageDas.select(SqlFilterBuilder.create(CargoStorageEo.class).eq("warehouse_id", (Object)id).eq("inventory_share_status", (Object)1).eo());
        if (!CollectionUtils.isEmpty((Collection)cargoStorageEos)) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData(cargoStorageEos.stream().map(b -> {
                InventoryCountDto dto = new InventoryCountDto();
                dto.setWarehouseId(b.getWarehouseId());
                dto.setCargoId(b.getCargoId());
                BigDecimal available = b.getAvailable();
                dto.setNum(0 == status ? available.negate() : available);
                dto.setNo(TradeUtil.generateTradeNo(b.getCargoId().toString()));
                return dto;
            }).collect(Collectors.toList()));
            this.commonsMqService.publishMessage("inventoryChangeInMessagetest", (Object)messageVo);
        }
        return RestResponse.VOID;
    }

    public Integer addCreditValue(String warehouseCode, Integer changeValue) {
        return this.wareHouseService.addCreditValue(warehouseCode, changeValue);
    }

    public RestResponse<Void> lockWarehouse(WarehouseLockReqDto warehouseLockReqDto) {
        this.wareHouseService.lockWarehouse(warehouseLockReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> unlockWarehouse(WarehouseUnLockReqDto warehouseUnLockReqDto) {
        this.wareHouseService.unlockWarehouse(warehouseUnLockReqDto);
        return RestResponse.VOID;
    }
}

