/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IAddressService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="storageOrderQueryApi")
public class StorageOrderQueryApiImpl
implements IStorageOrderQueryApi {
    @Resource
    private IStorageOrderService storageOrderService;
    @Resource
    private IAddressService addressService;
    @Resource
    private IStorageOrderDetailService storageOrderDetailService;
    @Resource
    private ICargoService cargoService;
    @Resource
    private WarehouseDas warehouseDas;

    public RestResponse<StorageOrderCombineRespDto> queryById(Long id) {
        StorageOrderCombineRespDto combineRespDto = new StorageOrderCombineRespDto();
        StorageOrderEo orderEo = this.storageOrderService.queryById(id);
        if (orderEo != null) {
            StorageOrderRespDto orderRespDto = new StorageOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderRespDto);
            List<StorageOrderDetailEo> list = this.storageOrderDetailService.queryByOrderId(orderEo.getId());
            ArrayList detailRespDtoList = new ArrayList();
            CubeBeanUtils.copyCollection(detailRespDtoList, list, StorageOrderDetailRespDto.class);
            WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.getMapper().findById(WarehouseEo.class, orderEo.getWarehouseId());
            if (null != warehouseEo) {
                orderRespDto.setWarehouseName(warehouseEo.getName());
            }
            combineRespDto.setStorageOrderRespDto(orderRespDto);
            List<CargoRespDto> cargoRespDtos = this.cargoService.getByIds(detailRespDtoList.stream().map(StorageOrderDetailRespDto::getCargoId).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty(cargoRespDtos)) {
                Map<Long, CargoRespDto> cargoRespDtoMap = cargoRespDtos.stream().collect(Collectors.toMap(CargoRespDto::getId, cargoRespDto -> cargoRespDto));
                combineRespDto.setDetailRespDtoList(detailRespDtoList.stream().peek(d -> {
                    CargoRespDto cargoRespDto = (CargoRespDto)cargoRespDtoMap.get(d.getCargoId());
                    d.setCargoCode(cargoRespDto.getCode());
                    d.setCargoName(cargoRespDto.getName());
                    d.setArtNo(cargoRespDto.getArtNo());
                    d.setBarCode(cargoRespDto.getBarCode());
                }).collect(Collectors.toList()));
            }
            combineRespDto.setAddressRespDto(this.addressService.queryByRelatedId(orderEo.getId()));
        }
        return new RestResponse((Object)combineRespDto);
    }

    public RestResponse<PageInfo<StorageOrderCombineRespDto>> queryFilterByPage(String filter, Integer pageNum, Integer pageSize) {
        StorageOrderReqDto storageOrderReqDto = (StorageOrderReqDto)JSON.parseObject((String)filter, StorageOrderReqDto.class);
        PageInfo rePageInfo = new PageInfo();
        if (storageOrderReqDto == null) {
            rePageInfo.setPageNum(pageNum.intValue());
            rePageInfo.setPageSize(pageSize.intValue());
            return new RestResponse((Object)rePageInfo);
        }
        if (storageOrderReqDto.getTenantId() == null || storageOrderReqDto.getInstanceId() == null) {
            InventoryBusinessRuntimeException.parameterError();
        }
        StorageOrderEo storageOrderEo = new StorageOrderEo();
        DtoHelper.dto2Eo((BaseVo)storageOrderReqDto, (BaseEo)storageOrderEo);
        PageInfo<StorageOrderEo> storageOrderEoPageInfo = this.storageOrderService.queryPage(storageOrderEo, pageNum, pageSize);
        if (storageOrderEoPageInfo == null || CollectionUtils.isEmpty((Collection)storageOrderEoPageInfo.getList())) {
            return new RestResponse((Object)rePageInfo);
        }
        BeanUtils.copyProperties(storageOrderEoPageInfo, (Object)rePageInfo);
        ArrayList<StorageOrderCombineRespDto> combineRespDtoList = new ArrayList<StorageOrderCombineRespDto>();
        for (StorageOrderEo orderEo : storageOrderEoPageInfo.getList()) {
            StorageOrderCombineRespDto combineRespDto = new StorageOrderCombineRespDto();
            StorageOrderRespDto storageOrderRespDto = new StorageOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)storageOrderRespDto);
            combineRespDto.setStorageOrderRespDto(storageOrderRespDto);
            List<StorageOrderDetailEo> list = this.storageOrderDetailService.queryByOrderId(orderEo.getId());
            StorageOrderRespDto orderRespDto = new StorageOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderRespDto);
            ArrayList detailRespDtoList = new ArrayList();
            DtoHelper.eoList2DtoList(list, detailRespDtoList, StorageOrderDetailRespDto.class);
            combineRespDto.setDetailRespDtoList(detailRespDtoList);
            combineRespDtoList.add(combineRespDto);
        }
        rePageInfo.setList(combineRespDtoList);
        return new RestResponse((Object)rePageInfo);
    }

    public RestResponse<PageInfo<StorageOrderRespDto>> queryByPage(StorageOrderPageReqDto storageOrderPageReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.storageOrderService.queryByPage(storageOrderPageReqDto, pageNum, pageSize));
    }
}

