/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.PositionQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCoordinateQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ElectricFenceRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.PositionQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ServiceAreaRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseDeliveryQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSubTypeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseTypeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryPartyEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IElectricFenceService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IPositionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRAreaWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRServiceAreaService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IServiceAreaService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RAreaWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.vo.WarehouseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="warehouseQueryApi")
public class WarehouseQueryApiImpl
implements IWarehouseQueryApi {
    @Resource
    private IWarehouseService warehouseService;
    @Resource
    private IPositionService positionService;
    @Resource
    IServiceAreaService serviceAreaService;
    @Resource
    IRAreaWarehouseService areaWarehouseService;
    @Resource
    IElectricFenceService electricFenceService;
    @Resource
    IRAreaWarehouseService irAreaWarehouseService;
    @Resource
    RAreaWarehouseDas rAreaWarehouseDas;
    @Resource
    IRServiceAreaService irServiceAreaService;
    @Resource
    RServiceAreaDas rServiceAreaDas;
    @Resource
    private WarehouseDeliveryDas warehouseDeliveryDas;

    public RestResponse<WarehouseRespDto> queryWarehouseById(Long id, String filter) {
        WarehouseRespDto warehouseRespDto;
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        if ((warehouseRespDto = this.warehouseService.queryById(id)) != null) {
            List<AreaDto> areaDtoList = this.warehouseService.queryWarehouseAreaById(id);
            warehouseRespDto.setServiceAreaList(areaDtoList);
            ElectricFenceRespDto electricFenceRespDto = this.electricFenceService.queryByWarehouseId(warehouseRespDto.getId());
            if (electricFenceRespDto != null) {
                warehouseRespDto.setGeoFence(electricFenceRespDto.getParamsValue());
            }
        }
        return new RestResponse((Object)warehouseRespDto);
    }

    public RestResponse<WarehouseRespDto> queryWarehouseBaseById(Long id) {
        return this.warehouseService.queryById(id);
    }

    public RestResponse<WarehouseRespDto> queryWarehouseByCode(String code, String filter) {
        WarehouseRespDto warehouseRespDto;
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        if ((warehouseRespDto = this.warehouseService.queryByCode(code)) != null) {
            List<AreaDto> areaDtoList = this.warehouseService.queryWarehouseAreaById(warehouseRespDto.getId());
            warehouseRespDto.setServiceAreaList(areaDtoList);
            ElectricFenceRespDto electricFenceRespDto = this.electricFenceService.queryByWarehouseId(warehouseRespDto.getId());
            if (electricFenceRespDto != null) {
                warehouseRespDto.setGeoFence(electricFenceRespDto.getParamsValue());
            }
        }
        return new RestResponse((Object)warehouseRespDto);
    }

    public RestResponse<PageInfo<WarehouseRespDto>> queryWarehouseByPage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseEo warehouseEo = new WarehouseEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            warehouseEo = (WarehouseEo)JSON.parseObject((String)filter, WarehouseEo.class);
        }
        warehouseEo.setOrderByDesc("updateTime");
        return new RestResponse(this.warehouseService.queryByPage(warehouseEo, pageNum, pageSize));
    }

    public RestResponse<List<WarehouseRespDto>> queryWarehouseByGroupId(Long groupId, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse(this.warehouseService.queryByGroupId(groupId));
    }

    public RestResponse<PositionQueryRespDto> queryPositionById(Long id, String filter) {
        return new RestResponse((Object)this.positionService.getById(id));
    }

    public RestResponse<PositionQueryRespDto> queryPositionByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse((Object)this.positionService.getByCode(code, requestDto.getInstanceId(), requestDto.getTenantId()));
    }

    public RestResponse<List<PositionQueryRespDto>> queryPositionByList(String filter) {
        PositionQueryReqDto positionQueryReqDto = (PositionQueryReqDto)JSON.parseObject((String)filter, PositionQueryReqDto.class);
        return new RestResponse(this.positionService.queryByList(positionQueryReqDto));
    }

    public RestResponse<PageInfo<PositionQueryRespDto>> queryPositionByPage(String filter, Integer pageNum, Integer pageSize) {
        PositionQueryReqDto positionQueryReqDto = (PositionQueryReqDto)JSON.parseObject((String)filter, PositionQueryReqDto.class);
        return new RestResponse(this.positionService.queryByPage(positionQueryReqDto, pageNum, pageSize));
    }

    public RestResponse<ServiceAreaRespDto> queryServiceAreaById(Long id, String filter) {
        return new RestResponse((Object)this.serviceAreaService.getById(id));
    }

    public RestResponse<PageInfo<ServiceAreaRespDto>> queryServiceAreaByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.serviceAreaService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<PageInfo<WarehouseRespDto>> queryWarehousePage(WarehouseQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<WarehouseRespDto> lists = this.warehouseService.queryByPage(queryReqDto, pageNum, pageSize);
        return new RestResponse(lists);
    }

    public RestResponse<PageInfo<WarehouseRespDto>> queryByLogAndLat(WarehouseCoordinateQueryReqDto coordinateQueryReqDto) {
        if (null == coordinateQueryReqDto.getLongitude() || null == coordinateQueryReqDto.getLatitude()) {
            throw new BizException("\u5f53\u524d\u4f4d\u7f6e\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == coordinateQueryReqDto.getPageNum()) {
            throw new BizException("\u5f53\u524d\u9875\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == coordinateQueryReqDto.getPageSize()) {
            throw new BizException("\u6bcf\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PageInfo dtoPageInfo = new PageInfo();
        dtoPageInfo.setPageNum(coordinateQueryReqDto.getPageNum().intValue());
        dtoPageInfo.setPages(coordinateQueryReqDto.getPageSize().intValue());
        PageInfo<WarehouseVo> voPageInfo = this.warehouseService.queryByLogAndLat(coordinateQueryReqDto);
        BeanUtils.copyProperties(voPageInfo, (Object)dtoPageInfo);
        return new RestResponse((Object)dtoPageInfo);
    }

    public RestResponse<List<WarehouseDeliveryQueryRespDto>> queryWarehouseDeliveryList(Long warehousesId) {
        List<Object> dtoList = Lists.newLinkedList();
        dtoList = Stream.of(DeliveryPartyEnum.values()).map(type -> {
            WarehouseDeliveryQueryRespDto dto = new WarehouseDeliveryQueryRespDto();
            dto.setCode(Integer.valueOf(type.getCode()));
            dto.setName(type.getName());
            dto.setWarehouseId(warehousesId);
            return dto;
        }).collect(Collectors.toList());
        return new RestResponse((Object)dtoList);
    }

    public RestResponse<List<WarehouseTypeDto>> queryWarehouseType(Integer parentCode) {
        List list = Stream.of(WarehouseTypeEnum.values()).filter(e -> {
            if (parentCode != null) {
                return parentCode.intValue() == e.getCode();
            }
            return true;
        }).map(e -> {
            WarehouseTypeDto dto = new WarehouseTypeDto();
            dto.setCode(Integer.valueOf(e.getCode()));
            dto.setName(e.getName());
            ArrayList subTypeList = Lists.newArrayList();
            List subEnumList = WarehouseSubTypeEnum.getSubListByParentCode((int)e.getCode());
            if (!CollectionUtils.isEmpty((Collection)subEnumList)) {
                subEnumList.forEach(subE -> {
                    WarehouseSubTypeDto sub = new WarehouseSubTypeDto();
                    sub.setParentCode(Integer.valueOf(subE.getParentCode()));
                    sub.setCode(Integer.valueOf(subE.getCode()));
                    sub.setName(subE.getName());
                    subTypeList.add(sub);
                });
            }
            dto.setSubTypeList((List)subTypeList);
            return dto;
        }).collect(Collectors.toList());
        return new RestResponse(list);
    }

    public RestResponse<List<WarehouseRespDto>> queryListByCodes(List<String> codes) {
        return new RestResponse(this.warehouseService.queryListByCodes(codes));
    }
}

