/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.CargoStorageProcess;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@MQDesc(tag="cargo_storage7", consumer="cargo_storage7", msgType="publish")
public class CargoStorageNewProcess
implements IMessageProcessor<MessageVo> {
    private Logger logger = LoggerFactory.getLogger(CargoStorageProcess.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CargoStorageDas cargoStorageDas;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(MessageVo messageVo) {
        String messageStr = JSON.toJSONString((Object)messageVo);
        this.logger.info("\u83b7\u53d6\u5230\u5e93\u5b58\u4e2d\u5fc3\u6d88\u606f\uff1a{}", (Object)messageStr);
        String cacheKey = null;
        if (messageVo == null) {
            this.logger.error("mq\u6d88\u606f\u4f53\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        JSONObject cargoStorageChangeMsg = JSON.parseObject((String)String.valueOf(messageVo.getData()));
        CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto = (CargoStorageInfoCreateReqDto)JSONObject.toJavaObject((JSON)cargoStorageChangeMsg, CargoStorageInfoCreateReqDto.class);
        cacheKey = "change_order_no_mq" + cargoStorageInfoCreateReqDto.getWarehouseId() + cargoStorageInfoCreateReqDto.getCargoId() + cargoStorageInfoCreateReqDto.getType();
        String cache = (String)this.cacheService.getCache(cacheKey, String.class);
        if (StringUtils.isEmpty((CharSequence)cache)) {
            try {
                this.cacheService.setCache(cacheKey, (Object)"1");
                ArrayList<CargoStorageEo> updateDtos = new ArrayList<CargoStorageEo>(1);
                CargoStorageEo cargoStorageEo = (CargoStorageEo)EoUtil.dtoToEo((BaseVo)cargoStorageInfoCreateReqDto, CargoStorageEo.class);
                cargoStorageEo.setAvailable(cargoStorageInfoCreateReqDto.getNum());
                if (cargoStorageInfoCreateReqDto.getType() != null && 1 == cargoStorageInfoCreateReqDto.getType()) {
                    cargoStorageEo.setWarehouseSubType(cargoStorageInfoCreateReqDto.getType());
                }
                cargoStorageEo.setUpdateTime(new Date());
                updateDtos.add(cargoStorageEo);
                this.cargoStorageDas.updateListByid(updateDtos);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                MessageResponse messageResponse = MessageResponse.ERROR;
                return messageResponse;
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        } else {
            this.logger.info("\u6d88\u606f\u5df2\u7ecf\u5904\u7406\u8fc7\u4e86");
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }
}

