/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.CargoStorageChangeVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageChangeLogEo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@MQDesc(tag="cargo_storage6", consumer="cargo_storage6", msgType="publish")
public class CargoStorageProcess
implements IMessageProcessor<MessageVo> {
    private Logger logger = LoggerFactory.getLogger(CargoStorageProcess.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    ICargoStorageService cargoStorageService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(MessageVo messageVo) {
        String messageStr = JSON.toJSONString((Object)messageVo);
        this.logger.info("\u83b7\u53d6\u5230\u5e93\u5b58\u4e2d\u5fc3\u6d88\u606f\uff1a{}", (Object)messageStr);
        String cacheKey = null;
        if (messageVo == null) {
            this.logger.error("mq\u6d88\u606f\u4f53\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        JSONObject cargoStorageChangeMsg = JSON.parseObject((String)String.valueOf(messageVo.getData()));
        CargoStorageChangeVo cargoStorageChangeVo = (CargoStorageChangeVo)((Object)JSONObject.toJavaObject((JSON)cargoStorageChangeMsg, CargoStorageChangeVo.class));
        List<StorageChangeLogEo> storageChangeList = cargoStorageChangeVo.getStorageChangeList();
        cacheKey = "change_order_no_mq" + cargoStorageChangeVo.getStatus() + storageChangeList.get(0).getOrderNo() + storageChangeList.get(0).getChangeType();
        boolean isNotExit = this.cacheService.add(cacheKey, (Object)"1");
        if (isNotExit) {
            try {
                if (!CollectionUtils.isNotEmpty(storageChangeList)) return MessageResponse.SUCCESS;
                this.cargoStorageService.modifyStorageChange(storageChangeList, cargoStorageChangeVo.getStatus());
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                MessageResponse messageResponse = MessageResponse.ERROR;
                return messageResponse;
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        } else {
            this.logger.info("\u6d88\u606f\u5df2\u7ecf\u5904\u7406\u8fc7\u4e86");
            return MessageResponse.SUCCESS;
        }
    }
}

