/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ChangeLogTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageAdjustStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventoryCountDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.WarehouseCargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.NOUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustCargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdRefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@MQDesc(tag="inventoryChangeInMessagetest", consumer="inventoryChangeInMessagetest", msgType="publish")
public class NewInventoryCountProcess
implements IMessageProcessor<MessageVo> {
    private static Logger logger = LoggerFactory.getLogger(NewInventoryCountProcess.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CargoDas cargoDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private StorageAdjustDas storageAdjustDas;
    @Resource
    private StorageAdjustCargoDas storageAdjustCargoDas;
    @Resource
    private ChangeLogDas changeLogDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private RefWarehouseDas refWarehouseDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private WarehouseCargoService warehouseCargoService;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(MessageVo message) {
        WarehouseEo warehouseEo;
        int shareCode;
        logger.info("\u5e93\u5b58\u8ba1\u7b97\u5f00\u59cb\uff1a{}", (Object)message.getData().toString());
        List inventoryCountDtos = (List)message.getData();
        Long warehouseId = ((InventoryCountDto)inventoryCountDtos.get(0)).getWarehouseId();
        List cargoIds = inventoryCountDtos.stream().map(InventoryCountDto::getCargoId).collect(Collectors.toList());
        String nos = StringUtils.join((Iterable)inventoryCountDtos.stream().map(InventoryCountDto::getNo).collect(Collectors.toList()), (String)",");
        String Key = "INVENTORY_COUNT" + warehouseId + nos;
        boolean lock = this.cacheService.add(Key, (Object)172800);
        if (!lock) {
            logger.info("\u5e93\u5b58\u8ba1\u7b97\u5e42\u7b49\u6821\u9a8c\u5df2\u7ecf\u6d88\u8d39\u8fc7\u8be5\u6d88\u606f\uff1a{}\uff0c\u76f4\u63a5\u8fd4\u56de\u3002", (Object)JSONObject.toJSONString((Object)message));
            return MessageResponse.SUCCESS;
        }
        final int logicalCode = WarehouseTypeEnum.LOGICAL.getCode();
        if (!new ArrayList<Integer>(shareCode = WarehouseTypeEnum.SHARE.getCode()){
            final /* synthetic */ int val$shareCode;
            {
                this.val$shareCode = n2;
                this.add(logicalCode);
                this.add(this.val$shareCode);
            }
        }.contains(Integer.valueOf((warehouseEo = (WarehouseEo)this.warehouseDas.getMapper().findById(WarehouseEo.class, warehouseId)).getType())) && !warehouseEo.getInventoryShareStatus().booleanValue()) {
            logger.info("\u53ea\u6709\u903b\u8f91\u4ed3\u548c\u5171\u4eab\u4ed3\u89e6\u53d1\u8ba1\u7b97\uff0c\u6e20\u9053\u4ed3\u89e6\u53d1\u7b2c\u4e09\u65b9\u540c\u6b65");
            return MessageResponse.SUCCESS;
        }
        List refWarehouseEos = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).eq("warehouse_id", (Object)warehouseId).eq("type", (Object)2).eo());
        if (CollectionUtils.isEmpty((Collection)refWarehouseEos)) {
            logger.info("\u8be5\u4ed3\u5e93\u672a\u5173\u8054\u5176\u4ed6\u4ed3\u5e93");
            return MessageResponse.SUCCESS;
        }
        Map<String, BigDecimal> refWarehouseMap = refWarehouseEos.stream().collect(Collectors.toMap(k -> k.getRefWarehouseId() + (null == k.getCargoId() ? "" : k.getCargoId()), StdRefWarehouseEo::getProportion));
        List refWarehouseIds = refWarehouseEos.stream().map(StdRefWarehouseEo::getRefWarehouseId).distinct().collect(Collectors.toList());
        Map<Integer, List<RefWarehouseEo>> listMap = refWarehouseEos.stream().collect(Collectors.groupingBy(StdRefWarehouseEo::getRefWarehouseType));
        List<RefWarehouseEo> shareWarehouseEos = listMap.get(shareCode);
        List cargoStorageEos = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).eq("warehouse_id", (Object)warehouseId).in("cargo_id", (Object)StringUtils.join(cargoIds, (String)",")).eq("inventory_share_status", (Object)1).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        List refCargoStorageEos = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).in("warehouse_id", (Object)StringUtils.join(refWarehouseIds, (String)",")).in("cargo_id", (Object)StringUtils.join(cargoIds, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        if (CollectionUtils.isEmpty((Collection)refCargoStorageEos)) {
            logger.info("\u5173\u8054\u4ed3\u5e93\u90fd\u6ca1\u6709\u53d8\u52a8\u8d27\u54c1\u4e0d\u8ba1\u7b97");
            return MessageResponse.SUCCESS;
        }
        Map<Long, List<CargoStorageEo>> cargoStorageMap = refCargoStorageEos.stream().collect(Collectors.groupingBy(StdCargoStorageEo::getCargoId));
        Map<Long, CargoStorageEo> storageEoMap = refCargoStorageEos.stream().collect(Collectors.toMap(k -> k.getWarehouseId() + k.getCargoId(), r -> r));
        if (CollectionUtils.isEmpty((Collection)cargoStorageEos)) {
            logger.info("\u8c03\u6574\u7684\u4ed3\u5e93\u8d27\u54c1\u90fd\u672a\u5171\u4eab\u4e0d\u7528\u8ba1\u7b97");
            return MessageResponse.SUCCESS;
        }
        List cargoStorageIds = cargoStorageEos.stream().map(StdCargoStorageEo::getCargoId).collect(Collectors.toList());
        ArrayList<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateAddReqDtos = new ArrayList<CargoStorageInfoCreateReqDto>();
        ArrayList<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateSubReqDtos = new ArrayList<CargoStorageInfoCreateReqDto>();
        inventoryCountDtos.stream().forEach(b -> {
            Long cargoId = b.getCargoId();
            if (cargoStorageIds.contains(cargoId)) {
                if (null != b.getRefWarehouseId()) {
                    CargoStorageInfoCreateReqDto dto = new CargoStorageInfoCreateReqDto();
                    dto.setWarehouseId(b.getRefWarehouseId());
                    dto.setCargoId(cargoId);
                    BigDecimal proportion = (BigDecimal)refWarehouseMap.get(b.getRefWarehouseId() + "" + b.getCargoId());
                    if (null != proportion) {
                        dto.setNum(b.getNum().multiply(proportion.divide(new BigDecimal("100"), 2, 4)).setScale(2, 4));
                        if (dto.getNum().compareTo(BigDecimal.ZERO) > -1) {
                            dto.setType(Integer.valueOf(3));
                            cargoStorageInfoCreateAddReqDtos.add(dto);
                        } else {
                            dto.setType(Integer.valueOf(4));
                            cargoStorageInfoCreateSubReqDtos.add(dto);
                        }
                    }
                } else {
                    List cargoStorageEoList = (List)cargoStorageMap.get(cargoId);
                    if (CollectionUtils.isNotEmpty((Collection)cargoStorageEoList)) {
                        cargoStorageEoList.stream().forEach(c -> {
                            CargoStorageInfoCreateReqDto dto = new CargoStorageInfoCreateReqDto();
                            dto.setWarehouseId(c.getWarehouseId());
                            dto.setCargoId(cargoId);
                            BigDecimal proportion = (BigDecimal)refWarehouseMap.get(c.getWarehouseId() + c.getCargoId() + "");
                            if (null != proportion) {
                                dto.setNum(b.getNum().multiply(proportion.divide(new BigDecimal("100"), 2, 4)).setScale(2, 4));
                                if (dto.getNum().compareTo(BigDecimal.ZERO) > -1) {
                                    dto.setType(Integer.valueOf(3));
                                    cargoStorageInfoCreateAddReqDtos.add(dto);
                                } else {
                                    dto.setType(Integer.valueOf(4));
                                    cargoStorageInfoCreateSubReqDtos.add(dto);
                                }
                            }
                        });
                    }
                }
            }
        });
        if (CollectionUtils.isNotEmpty(cargoStorageInfoCreateAddReqDtos)) {
            this.warehouseCargoService.addCargoStorage(cargoStorageInfoCreateAddReqDtos);
        }
        if (CollectionUtils.isNotEmpty(cargoStorageInfoCreateSubReqDtos)) {
            this.warehouseCargoService.subCargoStorage(cargoStorageInfoCreateSubReqDtos);
        }
        Map<Long, CargoEo> cargoEoMap = this.cargoDas.selectPage(SqlFilterBuilder.create(CargoEo.class).in("id", (Object)StringUtils.join(cargoIds, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList().stream().collect(Collectors.toMap(BaseEo::getId, c -> c));
        cargoStorageInfoCreateAddReqDtos.addAll(cargoStorageInfoCreateSubReqDtos);
        Map<Long, List<CargoStorageInfoCreateReqDto>> wareHouseMap = cargoStorageInfoCreateAddReqDtos.stream().collect(Collectors.groupingBy(CargoStorageInfoCreateReqDto::getWarehouseId));
        ArrayList<StorageAdjustEo> storageAdjustEos = new ArrayList<StorageAdjustEo>();
        ArrayList storageAdjustCargoEos = new ArrayList();
        ArrayList changeLogEos = new ArrayList();
        for (Long wareId : wareHouseMap.keySet()) {
            List<CargoStorageInfoCreateReqDto> storageEos = wareHouseMap.get(wareId);
            StorageAdjustEo storageAdjustEo = new StorageAdjustEo();
            storageAdjustEo.setWarehouseId(wareId);
            storageAdjustEo.setCreatePerson("admin");
            storageAdjustEo.setUpdatePerson("admin");
            storageAdjustEo.setStatus(StorageAdjustStatusEnum.SUCCESS.getStatus());
            storageAdjustEo.setAdjustType("SYSTEM_ADJUST");
            storageAdjustEo.setDirection("\u4e2d\u53f0->\u4e2d\u53f0");
            storageAdjustEo.setAdjustMethod("CUMULATIVE");
            String no = NOUtil.generateNo();
            storageAdjustEo.setStorageAdjustNo(no);
            List adjustCargoEos = storageEos.stream().map(s -> {
                Long cargoId = s.getCargoId();
                StorageAdjustCargoEo storageAdjustCargoEo = new StorageAdjustCargoEo();
                ChangeLogEo changeLogEo = new ChangeLogEo();
                storageAdjustEo.setPositionId(Long.valueOf(0L));
                storageAdjustCargoEo.setStorageAdjustNo(no);
                CargoEo cargoEo = (CargoEo)cargoEoMap.get(cargoId);
                storageAdjustCargoEo.setCargoId(cargoId);
                storageAdjustCargoEo.setCreatePerson("admin");
                storageAdjustCargoEo.setUpdatePerson("admin");
                if (null != cargoEo) {
                    storageAdjustCargoEo.setCargoCode(cargoEo.getCode());
                    storageAdjustCargoEo.setCargoName(cargoEo.getName());
                    storageAdjustCargoEo.setCargoNo(cargoEo.getArtNo());
                    storageAdjustCargoEo.setCargoBarCode(cargoEo.getBarCode());
                    storageAdjustCargoEo.setClientName(cargoEo.getCustomerNo());
                    changeLogEo.setCargoNo(cargoEo.getArtNo());
                    changeLogEo.setCargoBarCode(cargoEo.getBarCode());
                    changeLogEo.setClientName(cargoEo.getCustomerNo());
                    changeLogEo.setCargoCode(cargoEo.getCode());
                    changeLogEo.setCargoName(cargoEo.getName());
                }
                changeLogEo.setRelevanceNo(no);
                changeLogEo.setCargoId(cargoId);
                changeLogEo.setWarehouseId(wareId.toString());
                storageAdjustCargoEo.setAdjustNum(s.getNum());
                changeLogEo.setWarehouseCode(warehouseEo.getCode());
                changeLogEo.setWarehouseName(warehouseEo.getName());
                changeLogEo.setWarehouseSubType(warehouseEo.getSubType());
                BigDecimal adjustNum = storageAdjustCargoEo.getAdjustNum();
                changeLogEo.setType(ChangeLogTypeEnum.STORAGE_ADJUST_ORDER.getStatus());
                CargoStorageEo cargoStorageEo = (CargoStorageEo)storageEoMap.get(s.getWarehouseId() + s.getCargoId());
                if (null == cargoStorageEo) {
                    logger.info("\u67e5\u8be2\u4e0d\u5230\u539f\u59cb\u5e93\u5b58:{}", (Object)(s.getWarehouseId() + s.getCargoId()));
                    return null;
                }
                changeLogEo.setOldNum(cargoStorageEo.getAvailable());
                changeLogEo.setChangeNum(adjustNum);
                changeLogEo.setNewNum(cargoStorageEo.getAvailable().add(adjustNum).compareTo(BigDecimal.ZERO) > 0 ? cargoStorageEo.getAvailable().add(adjustNum) : BigDecimal.ZERO);
                changeLogEos.add(changeLogEo);
                return storageAdjustCargoEo;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(adjustCargoEos)) continue;
            storageAdjustCargoEos.addAll(adjustCargoEos);
            storageAdjustEos.add(storageAdjustEo);
        }
        logger.info("\u751f\u6210\u5e93\u5b58\u8c03\u6574\u548c\u6d41\u6c34");
        this.storageAdjustDas.insertBatch(storageAdjustEos);
        this.storageAdjustCargoDas.insertBatch(storageAdjustCargoEos);
        this.changeLogDas.insertBatch(changeLogEos);
        if (CollectionUtils.isNotEmpty(shareWarehouseEos)) {
            logger.info("\u6709\u4e0a\u4e00\u5c42\u4ed3\uff0c\u53d1\u9001mq\uff1a{}", JSON.toJSON(shareWarehouseEos));
            List shareWarehouseIds = shareWarehouseEos.stream().map(StdRefWarehouseEo::getRefWarehouseId).collect(Collectors.toList());
            MessageVo messageVo = new MessageVo();
            messageVo.setData(cargoStorageInfoCreateAddReqDtos.stream().map(b -> {
                if (shareWarehouseIds.contains(b.getWarehouseId().toString())) {
                    InventoryCountDto dto = new InventoryCountDto();
                    dto.setWarehouseId(b.getWarehouseId());
                    dto.setCargoId(b.getCargoId());
                    dto.setNum(b.getNum());
                    dto.setNo(TradeUtil.generateTradeNo(b.getCargoId().toString()));
                    return dto;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            this.commonsMqService.publishMessage("inventoryChangeInMessagetest", (Object)messageVo);
        }
        logger.info("\u5e93\u5b58\u8ba1\u7b97\u540c\u6b65\u6210\u529f");
        return MessageResponse.SUCCESS;
    }
}

