/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ChangeLogTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageAdjustStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.InventoryCountProcess;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.NOUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustCargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdRefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageAdjustCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.connector.comm.dto.BizToExternalSystemReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PocInventoryCountProcess
implements IMessageProcessor<MessageVo> {
    private static Logger logger = LoggerFactory.getLogger(InventoryCountProcess.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CargoDas cargoDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private StorageAdjustDas storageAdjustDas;
    @Resource
    private StorageAdjustCargoDas storageAdjustCargoDas;
    @Resource
    private ChangeLogDas changeLogDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private RefWarehouseDas refWarehouseDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    Environment environment;
    private static final String INVENTORY_TIME = "INVENTORY_TIME";
    private static final String SHARE_ORG_INVENTORY = "SHARE_ORG_INVENTORY";
    private static final String CHANNEL_ORG_INVENTORY = "CHANNEL_ORG_INVENTORY";
    private static final String SHARE_ALL_INVENTORY = "SHARE_ALL_INVENTORY";
    private static final String CHANNEL_ALL_INVENTORY = "CHANNEL_ALL_INVENTORY";
    private static final String NEW_INV = "NEW_INV";

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(MessageVo message) {
        logger.info("\u5e93\u5b58\u8ba1\u7b97\u5f00\u59cb\uff1a{}", (Object)message.getData().toString());
        Map object = (Map)JSONObject.parseObject((String)message.getData().toString(), Map.class);
        boolean lock = this.cacheService.add((String)object.get("id"), object.get("id"), 172800);
        if (!lock) {
            logger.info("\u5e42\u7b49\u6821\u9a8c\u5df2\u7ecf\u6d88\u8d39\u8fc7\u8be5\u6d88\u606f\uff1a{}\uff0c\u76f4\u63a5\u8fd4\u56de\u3002", (Object)JSONObject.toJSONString((Object)message));
            return MessageResponse.SUCCESS;
        }
        int ecommerceWarehouseCode = WarehouseSubTypeEnum.CHANNEL_OMS_WAREHOUSE.getCode();
        int miniappWarehouseCode = WarehouseSubTypeEnum.CHANNEL_THIRD_PARTY_MINIAPP_WAREHOUSE.getCode();
        final int logicalCode = WarehouseTypeEnum.LOGICAL.getCode();
        final int shareCode = WarehouseTypeEnum.SHARE.getCode();
        int channelCode = WarehouseTypeEnum.CHANNEL.getCode();
        List select = this.storageAdjustDas.select(SqlFilterBuilder.create(StorageAdjustEo.class).eq("id", object.get("id")).eo());
        if (CollectionUtils.isEmpty((Collection)select)) {
            logger.info("\u6ca1\u6709\u8c03\u6574\u5355\u4e0d\u7528\u8ba1\u7b97");
            return MessageResponse.SUCCESS;
        }
        List warehouseIds = select.stream().map(StdStorageAdjustEo::getWarehouseId).collect(Collectors.toList());
        List cargoIds = this.storageAdjustCargoDas.selectPage(SqlFilterBuilder.create(StorageAdjustCargoEo.class).in("storage_adjust_no", (Object)StringUtils.join((Iterable)select.stream().map(StdStorageAdjustEo::getStorageAdjustNo).collect(Collectors.toList()), (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(10000000)).getList().stream().map(StdStorageAdjustCargoEo::getCargoId).distinct().collect(Collectors.toList());
        logger.info("\u8c03\u6574\u5355\u7684\u8d27\u54c1id\u4e3a\uff1a{}", (Object)JSON.toJSONString(cargoIds));
        List warehouseEos = this.warehouseDas.selectPage(SqlFilterBuilder.create(WarehouseEo.class).in("type", (Object)StringUtils.join((Iterable)new ArrayList<Integer>(){
            {
                this.add(logicalCode);
                this.add(shareCode);
            }
        }, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        if (CollectionUtils.isEmpty((Collection)warehouseEos)) {
            logger.info("\u53ea\u6709\u903b\u8f91\u4ed3\u548c\u5171\u4eab\u4ed3\u89e6\u53d1\u8ba1\u7b97\uff0c\u6e20\u9053\u4ed3\u89e6\u53d1\u7b2c\u4e09\u65b9\u540c\u6b65");
            return MessageResponse.SUCCESS;
        }
        logger.info("\u67e5\u8be2\u51fa\u7684\u4ed3\u5e93\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)warehouseEos));
        Map<Long, WarehouseEo> longWarehouseEoMap = warehouseEos.stream().collect(Collectors.toMap(BaseEo::getId, w -> w));
        WarehouseEo warehouseEo1 = longWarehouseEoMap.get(warehouseIds.get(0));
        if (null == warehouseEo1) {
            logger.info("\u53ea\u6709\u903b\u8f91\u4ed3\u548c\u5171\u4eab\u4ed3\u89e6\u53d1\u8ba1\u7b97\uff0c\u6e20\u9053\u4ed3\u89e6\u53d1\u7b2c\u4e09\u65b9\u540c\u6b65");
            return MessageResponse.SUCCESS;
        }
        String inventoryShareType = warehouseEo1.getInventoryShareType().toString();
        List refWarehouseEos = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).in("warehouse_id", (Object)StringUtils.join(warehouseIds, (String)",")).eq("type", (Object)2).eo());
        if (CollectionUtils.isEmpty((Collection)refWarehouseEos)) {
            logger.info("\u8be5\u4ed3\u5e93\u672a\u5173\u8054\u5176\u4ed6\u4ed3\u5e93");
            return MessageResponse.SUCCESS;
        }
        Map<Integer, List<RefWarehouseEo>> listMap = refWarehouseEos.stream().collect(Collectors.groupingBy(StdRefWarehouseEo::getRefWarehouseType));
        List<RefWarehouseEo> shareWarehouseEos = listMap.get(shareCode);
        List<RefWarehouseEo> channelWarehouseEos = listMap.get(channelCode);
        List refWarehouseIds = refWarehouseEos.stream().map(StdRefWarehouseEo::getRefWarehouseId).distinct().collect(Collectors.toList());
        List refWarehouseEos1 = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).in("ref_warehouse_id", (Object)StringUtils.join(refWarehouseIds, (String)",")).eq("type", (Object)2).eo());
        List warehouseIdList = refWarehouseEos1.stream().map(StdRefWarehouseEo::getWarehouseId).distinct().collect(Collectors.toList());
        List<RefWarehouseEo> shareWarehouseEos2 = refWarehouseEos1.stream().collect(Collectors.groupingBy(StdRefWarehouseEo::getRefWarehouseType)).get(shareCode);
        Map<String, List<WarehouseEo>> whListMap = warehouseEos.stream().collect(Collectors.groupingBy(StdWarehouseEo::getType));
        List<WarehouseEo> logicalWarehouseEoList = whListMap.get(logicalCode + "");
        List<WarehouseEo> shareWarehouseEoList = whListMap.get(shareCode + "");
        logger.info("\u67e5\u8be2\u51fa\u7684\u903b\u8f91\u4ed3\u4ed3\u5e93\u4e3a\uff1a{}", (Object)JSON.toJSONString(logicalWarehouseEoList));
        logger.info("\u67e5\u8be2\u51fa\u7684\u5171\u4eab\u4ed3\u4ed3\u5e93\u4e3a\uff1a{}", (Object)JSON.toJSONString(shareWarehouseEoList));
        ArrayList<Long> refShareWarehouseIds = new ArrayList();
        List<Object> shareWarehouseIds = new ArrayList();
        ArrayList<Long> channelWarehouseRefIds = new ArrayList();
        List channelWarehouseEos1 = new ArrayList();
        List shareWarehouseRefEos = new ArrayList();
        if ("1".equals(warehouseEo1.getType())) {
            if (logicalWarehouseEoList.size() > 1) {
                logger.info("\u591a\u903b\u8f91\u4ed3\u6709\u4e00\u4e2a\u5171\u4eab\u5c31\u9700\u8981\u8ba1\u7b97");
                warehouseIds.clear();
                warehouseIds = logicalWarehouseEoList.stream().map(s -> {
                    if (warehouseIdList.contains(s.getId().toString()) && s.getInventoryShareStatus().booleanValue() && s.getInventoryShareType().equals(warehouseEo1.getInventoryShareType())) {
                        return s.getId();
                    }
                    return null;
                }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(warehouseIds)) {
                    logger.info("\u591a\u903b\u8f91\u4ed3\u90fd\u672a\u5f00\u542f\u5e93\u5b58\u5171\u4eab\u4e0d\u8ba1\u7b97");
                    return MessageResponse.SUCCESS;
                }
                logger.info("\u9700\u8981\u8ba1\u7b97\u7684\u903b\u8f91\u4ed3id\u4e3a\uff1a{}", (Object)JSON.toJSONString(warehouseIds));
            } else {
                logger.info("\u53ea\u6709\u4e00\u4e2a\u903b\u8f91\u4ed3\u7684\u5224\u65ad");
                if (!warehouseEo1.getInventoryShareStatus().booleanValue()) {
                    logger.info("\u975e\u903b\u8f91\u4ed3\u6216\u8005\u672a\u5f00\u542f\u5e93\u5b58\u5171\u4eab\u4e0d\u8ba1\u7b97");
                    return MessageResponse.SUCCESS;
                }
            }
            if (CollectionUtils.isNotEmpty(shareWarehouseEos)) {
                shareWarehouseIds = shareWarehouseEos.stream().map(StdRefWarehouseEo::getRefWarehouseId).distinct().collect(Collectors.toList());
                List shareWarehouseRefs = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).in("warehouse_id", (Object)StringUtils.join(shareWarehouseIds, (String)",")).eq("type", (Object)2).eo());
                if (CollectionUtils.isNotEmpty((Collection)shareWarehouseRefs)) {
                    channelWarehouseRefIds = shareWarehouseRefs.stream().map(s -> Long.valueOf(s.getRefWarehouseId())).distinct().collect(Collectors.toList());
                    channelWarehouseEos1 = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).in("ref_warehouse_id", (Object)StringUtils.join(channelWarehouseRefIds, (String)",")).eq("type", (Object)2).eo());
                    List shareWarehouseRefIds = channelWarehouseEos1.stream().map(StdRefWarehouseEo::getWarehouseId).distinct().collect(Collectors.toList());
                    shareWarehouseRefEos = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).in("warehouse_id", (Object)StringUtils.join(shareWarehouseRefIds, (String)",")).eq("type", (Object)2).eo());
                    if (shareWarehouseEoList.size() > 1) {
                        refShareWarehouseIds = shareWarehouseEoList.stream().map(s -> {
                            if (shareWarehouseRefIds.contains(s.getId().toString()) && s.getInventoryShareStatus().booleanValue()) {
                                return s.getId();
                            }
                            return null;
                        }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    } else {
                        logger.info("\u53ea\u6709\u4e00\u4e2a\u5171\u4eab\u4ed3\u7684\u5224\u65ad");
                        if (shareWarehouseEoList.get(0).getInventoryShareStatus().booleanValue()) {
                            refShareWarehouseIds.add((Long)((Object)Long.valueOf((String)shareWarehouseRefIds.get(0))));
                        }
                    }
                }
            }
        } else if (CollectionUtils.isNotEmpty(channelWarehouseEos)) {
            channelWarehouseRefIds = channelWarehouseEos.stream().map(s -> Long.valueOf(s.getRefWarehouseId())).collect(Collectors.toList());
            channelWarehouseEos1 = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).in("ref_warehouse_id", (Object)StringUtils.join(channelWarehouseRefIds, (String)",")).eo());
            List shareWarehouseRefIds = channelWarehouseEos1.stream().map(StdRefWarehouseEo::getWarehouseId).collect(Collectors.toList());
            shareWarehouseRefEos = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).in("warehouse_id", (Object)StringUtils.join(shareWarehouseRefIds, (String)",")).eo());
            if (shareWarehouseEoList.size() > 1) {
                refShareWarehouseIds = shareWarehouseEoList.stream().map(s -> {
                    if (shareWarehouseRefIds.contains(s.getId().toString()) && s.getInventoryShareStatus().booleanValue()) {
                        return s.getId();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            } else {
                logger.info("\u53ea\u6709\u4e00\u4e2a\u5171\u4eab\u4ed3\u7684\u5224\u65ad");
                if (shareWarehouseEoList.get(0).getInventoryShareStatus().booleanValue()) {
                    refShareWarehouseIds.add(Long.valueOf((String)shareWarehouseRefIds.get(0)));
                }
            }
        }
        List warehouseEoList = this.warehouseDas.selectPage(SqlFilterBuilder.create(WarehouseEo.class).in("id", (Object)StringUtils.join(shareWarehouseIds, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        List warehouseEos1 = this.warehouseDas.selectPage(SqlFilterBuilder.create(WarehouseEo.class).in("id", (Object)StringUtils.join(channelWarehouseRefIds, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        if (CollectionUtils.isEmpty((Collection)warehouseEoList) && CollectionUtils.isEmpty((Collection)warehouseEos1)) {
            logger.info("\u6ca1\u6709\u5171\u4eab\u4ed3\u548c\u6e20\u9053\u4ed3\u4e0d\u7528\u8ba1\u7b97");
            return MessageResponse.SUCCESS;
        }
        ArrayList allWarehouseEos = new ArrayList();
        allWarehouseEos.addAll(warehouseEoList);
        allWarehouseEos.addAll(warehouseEos1);
        List cargoStorageEos = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).in("warehouse_id", (Object)StringUtils.join(warehouseIds, (String)",")).eq("inventory_share_status", (Object)1).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        List cargoStorageEos1 = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).in("warehouse_id", (Object)StringUtils.join(refShareWarehouseIds, (String)",")).eq("inventory_share_status", (Object)1).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        if (CollectionUtils.isEmpty((Collection)cargoStorageEos) && CollectionUtils.isEmpty((Collection)cargoStorageEos1)) {
            logger.info("\u8c03\u6574\u7684\u4ed3\u5e93\u8d27\u54c1\u90fd\u672a\u5171\u4eab\u4e0d\u7528\u8ba1\u7b97");
            return MessageResponse.SUCCESS;
        }
        List cargoStorageEoList = cargoStorageEos.stream().map(c -> {
            if (cargoIds.contains(c.getCargoId())) {
                return c;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List cargoStorageEoList1 = cargoStorageEos1.stream().map(c -> {
            if (cargoIds.contains(c.getCargoId())) {
                return c;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cargoStorageEoList) && CollectionUtils.isEmpty(cargoStorageEoList1)) {
            logger.info("\u4ed3\u5e93\u5171\u4eab\u8d27\u54c1\u4e0d\u5728\u8c03\u6574\u5355\u8303\u56f4\u5185\u4e0d\u7528\u8ba1\u7b97");
            return MessageResponse.SUCCESS;
        }
        logger.info("\u53c2\u4e0e\u8ba1\u7b97\u7684\u4ed3\u5e93\u8d27\u54c1\u4e3a\u903b\u8f91\u4ed3\uff1a{}\uff0c\u5171\u4eab\u4ed3\uff1a{}", (Object)JSON.toJSONString(cargoStorageEoList), (Object)JSON.toJSONString(cargoStorageEoList1));
        List cargoStorageEoIds = cargoStorageEoList.stream().map(StdCargoStorageEo::getCargoId).collect(Collectors.toList());
        cargoStorageEoIds.addAll(cargoStorageEoList1.stream().map(StdCargoStorageEo::getCargoId).collect(Collectors.toList()));
        List storageEoList = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).in("warehouse_id", (Object)StringUtils.join((Iterable)allWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList()), (String)",")).in("cargo_id", (Object)StringUtils.join(cargoStorageEoIds, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        logger.info("\u76ee\u524d\u5e93\u5b58\u6570\uff1a{}", (Object)JSON.toJSONString((Object)storageEoList));
        ArrayList<CargoStorageEo> shareUpdateDtos = new ArrayList<CargoStorageEo>();
        ArrayList<CargoStorageEo> channelUpdateDtos = new ArrayList<CargoStorageEo>();
        Map<Long, List<CargoStorageEo>> cargoStorageIdMap = cargoStorageEoList.stream().collect(Collectors.groupingBy(StdCargoStorageEo::getCargoId));
        Map<Long, List<CargoStorageEo>> cargoStorageIdMap1 = cargoStorageEoList1.stream().collect(Collectors.groupingBy(StdCargoStorageEo::getCargoId));
        Map<Long, List<RefWarehouseEo>> refWarehouseCargoMap = shareWarehouseEos2.stream().collect(Collectors.groupingBy(StdRefWarehouseEo::getCargoId));
        Map<Long, List<RefWarehouseEo>> refWarehouseCargoMap1 = shareWarehouseRefEos.stream().collect(Collectors.groupingBy(StdRefWarehouseEo::getCargoId));
        if ("1".equals(inventoryShareType)) {
            logger.info("\u5168\u5c40\u5e93\u5b58\u8ba1\u7b97");
        } else {
            logger.info("\u5355\u7ec4\u7ec7\u5e93\u5b58\u8ba1\u7b97");
            for (Long key : cargoStorageIdMap.keySet()) {
                this.getInv(refShareWarehouseIds, refWarehouseCargoMap.get(key), cargoStorageIdMap, key, SHARE_ORG_INVENTORY, shareUpdateDtos, channelUpdateDtos);
            }
            for (Long key : cargoStorageIdMap1.keySet()) {
                this.getInv(channelWarehouseRefIds, refWarehouseCargoMap1.get(key), cargoStorageIdMap1, key, CHANNEL_ORG_INVENTORY, shareUpdateDtos, channelUpdateDtos);
            }
        }
        if (CollectionUtils.isEmpty(shareUpdateDtos) && CollectionUtils.isEmpty(channelUpdateDtos)) {
            logger.info("\u90fd\u4e3a\u7a7a\u4e0d\u9700\u8981\u66f4\u65b0");
            return MessageResponse.SUCCESS;
        }
        if (CollectionUtils.isNotEmpty((Collection)warehouseEoList) && CollectionUtils.isNotEmpty(shareUpdateDtos)) {
            logger.info("\u66f4\u65b0\u865a\u62df\u7535\u5546\u4ed3\u5e93\u5b58\uff0c\u4ed3\u5e93\u96c6\u5408:{}\uff0c\u8d27\u54c1\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)warehouseEoList), (Object)JSON.toJSONString(shareUpdateDtos));
            this.cargoStorageDas.updateListByid(shareUpdateDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)warehouseEos1) && CollectionUtils.isNotEmpty(channelUpdateDtos)) {
            logger.info("\u66f4\u65b0\u7b2c\u4e09\u65b9\u5c0f\u7a0b\u5e8f\u4ed3\u5e93\u5b58\uff0c\u4ed3\u5e93\u96c6\u5408:{}\uff0c\u8d27\u54c1\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)warehouseEos1), (Object)JSON.toJSONString(channelUpdateDtos));
            this.cargoStorageDas.updateListByid(channelUpdateDtos);
        }
        logger.info("\u751f\u6210\u5e93\u5b58\u8c03\u6574\u5355");
        Map<Long, CargoEo> cargoEoMap = this.cargoDas.selectPage(SqlFilterBuilder.create(CargoEo.class).in("id", (Object)StringUtils.join(cargoIds, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList().stream().collect(Collectors.toMap(BaseEo::getId, c -> c));
        Map<Long, WarehouseEo> warehouseEoMap = allWarehouseEos.stream().collect(Collectors.toMap(BaseEo::getId, w -> w));
        ArrayList changeLogEos = new ArrayList();
        Map<Long, List<CargoStorageEo>> wareHouseMap = storageEoList.stream().collect(Collectors.groupingBy(StdCargoStorageEo::getWarehouseId));
        ArrayList<StorageAdjustEo> storageAdjustEos = new ArrayList<StorageAdjustEo>();
        ArrayList storageAdjustCargoEos = new ArrayList();
        shareUpdateDtos.addAll(channelUpdateDtos);
        List sunIds = shareUpdateDtos.stream().map(StdCargoStorageEo::getCargoId).collect(Collectors.toList());
        logger.info("\u9700\u8981\u751f\u6210\u5e93\u5b58\u6d41\u6c34\u7684\u8d27\u54c1\uff1a{}", (Object)JSON.toJSONString(sunIds));
        for (Long wareId : wareHouseMap.keySet()) {
            List<CargoStorageEo> storageEos = wareHouseMap.get(wareId);
            StorageAdjustEo storageAdjustEo = new StorageAdjustEo();
            storageAdjustEo.setWarehouseId(wareId);
            storageAdjustEo.setCreatePerson("admin");
            storageAdjustEo.setUpdatePerson("admin");
            storageAdjustEo.setStatus(StorageAdjustStatusEnum.SUCCESS.getStatus());
            storageAdjustEo.setAdjustType("SYSTEM_ADJUST");
            storageAdjustEo.setDirection("\u4e2d\u53f0->\u4e2d\u53f0");
            storageAdjustEo.setAdjustMethod("CUMULATIVE");
            String no = NOUtil.generateNo();
            storageAdjustEo.setStorageAdjustNo(no);
            WarehouseEo warehouseEo = warehouseEoMap.get(wareId);
            List adjustCargoEos = storageEos.stream().map(s -> {
                Long cargoId = s.getCargoId();
                if (sunIds.contains(cargoId)) {
                    StorageAdjustCargoEo storageAdjustCargoEo = new StorageAdjustCargoEo();
                    ChangeLogEo changeLogEo = new ChangeLogEo();
                    storageAdjustEo.setPositionId(s.getPositionId());
                    storageAdjustCargoEo.setStorageAdjustNo(no);
                    CargoEo cargoEo = (CargoEo)cargoEoMap.get(cargoId);
                    storageAdjustCargoEo.setCargoId(cargoId);
                    storageAdjustCargoEo.setCreatePerson("admin");
                    storageAdjustCargoEo.setUpdatePerson("admin");
                    storageAdjustCargoEo.setCargoCode(s.getCargoCode());
                    storageAdjustCargoEo.setCargoName(s.getCargoName());
                    if (null != cargoEo) {
                        storageAdjustCargoEo.setCargoNo(cargoEo.getArtNo());
                        storageAdjustCargoEo.setCargoBarCode(cargoEo.getBarCode());
                        storageAdjustCargoEo.setClientName(cargoEo.getCustomerNo());
                        changeLogEo.setCargoNo(cargoEo.getArtNo());
                        changeLogEo.setCargoBarCode(cargoEo.getBarCode());
                        changeLogEo.setClientName(cargoEo.getCustomerNo());
                    }
                    changeLogEo.setRelevanceNo(no);
                    changeLogEo.setCargoId(cargoId);
                    changeLogEo.setCargoCode(s.getCargoCode());
                    changeLogEo.setCargoName(s.getCargoName());
                    changeLogEo.setWarehouseId(wareId.toString());
                    if (null != warehouseEo) {
                        Integer subType = warehouseEo.getSubType();
                        String type = warehouseEo.getType();
                        if ("0".equals(inventoryShareType)) {
                            storageAdjustCargoEo.setAdjustNum(type.equals(shareCode + "") ? new BigDecimal((Long)this.cacheService.getCache("SHARE_ORG_INVENTORYNEW_INV" + s.getWarehouseId() + cargoId, Long.TYPE)) : new BigDecimal((Long)this.cacheService.getCache("CHANNEL_ORG_INVENTORYNEW_INV" + s.getWarehouseId() + cargoId, Long.TYPE)));
                        } else {
                            storageAdjustCargoEo.setAdjustNum(ecommerceWarehouseCode == subType ? new BigDecimal((Long)this.cacheService.getCache("SHARE_ALL_INVENTORYNEW_INV" + s.getWarehouseId() + cargoId, Long.TYPE)) : new BigDecimal((Long)this.cacheService.getCache("CHANNEL_ALL_INVENTORYNEW_INV" + s.getWarehouseId() + cargoId, Long.TYPE)));
                        }
                        changeLogEo.setWarehouseCode(warehouseEo.getCode());
                        changeLogEo.setWarehouseName(warehouseEo.getName());
                        changeLogEo.setWarehouseSubType(subType);
                    }
                    BigDecimal adjustNum = storageAdjustCargoEo.getAdjustNum();
                    changeLogEo.setType(ChangeLogTypeEnum.STORAGE_ADJUST_ORDER.getStatus());
                    changeLogEo.setOldNum(s.getAvailable());
                    changeLogEo.setChangeNum(adjustNum);
                    changeLogEo.setNewNum(s.getAvailable().add(adjustNum).compareTo(BigDecimal.ZERO) > 0 ? s.getAvailable().add(adjustNum) : BigDecimal.ZERO);
                    changeLogEos.add(changeLogEo);
                    return storageAdjustCargoEo;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(adjustCargoEos)) continue;
            storageAdjustCargoEos.addAll(adjustCargoEos);
            storageAdjustEos.add(storageAdjustEo);
        }
        logger.info("\u751f\u6210\u5e93\u5b58\u6d41\u6c34");
        this.storageAdjustDas.insertBatch(storageAdjustEos);
        this.storageAdjustCargoDas.insertBatch(storageAdjustCargoEos);
        this.changeLogDas.insertBatch(changeLogEos);
        logger.info("\u5e93\u5b58\u8ba1\u7b97\u540c\u6b65\u6210\u529f");
        return MessageResponse.SUCCESS;
    }

    private void sendInventoryAdjust(List<BizToExternalSystemReqDto> bizToExternalSystemReqDtos) {
        logger.info("\u5e93\u5b58\u8ba1\u7b97\u7ed3\u679c\u540c\u6b65\uff0clists:{}", (Object)JSON.toJSONString(bizToExternalSystemReqDtos));
        try {
            bizToExternalSystemReqDtos.stream().forEach(b -> this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("YUNDT_CUBE_CONNECTOR_MQ_CONVERT"), "BIZ_TO_EXTERNAL_SYSTEM", b));
        }
        catch (Exception e) {
            logger.info("\u5e93\u5b58\u8ba1\u7b97\u7ed3\u679c\u540c\u6b65\u5f02\u5e38:{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void getAllInv(List<RefWarehouseEo> refWarehouseEos, Map<Long, List<CargoStorageEo>> cargoStorageIdMap, Long key, String s, List<CargoStorageEo> shareUpdateDtos, List<CargoStorageEo> channelUpdateDtos) {
        Map<Integer, List<RefWarehouseEo>> listMap = refWarehouseEos.stream().collect(Collectors.groupingBy(StdRefWarehouseEo::getType));
        List<RefWarehouseEo> refWarehouseEos1 = listMap.get(1);
        if (CollectionUtils.isNotEmpty(refWarehouseEos1)) {
            Map<String, BigDecimal> refWarehouseMap = refWarehouseEos1.stream().collect(Collectors.toMap(StdRefWarehouseEo::getRefWarehouseId, StdRefWarehouseEo::getProportion));
            BigDecimal sun = BigDecimal.ZERO;
            for (CargoStorageEo c : cargoStorageIdMap.get(key)) {
                sun = sun.add(c.getAvailable());
            }
            for (String s1 : refWarehouseMap.keySet()) {
                BigDecimal multiply = sun.multiply(refWarehouseMap.get(s1));
                long allInv = multiply.setScale(0, 1).longValue();
                long oldB2cOrgInv = this.cacheService.getCache(s + key, Long.TYPE) == null ? 0L : (Long)this.cacheService.getCache(s + key, Long.TYPE);
                logger.info("\u5168\u5c40\u5e93\u5b58\u539f\u5e93\u5b58\uff1a{},\u65b0\u5e93\u5b58:{}\uff0ckey:{}", new Object[]{oldB2cOrgInv, allInv, key});
                if (allInv == oldB2cOrgInv) continue;
                long newInv = allInv - oldB2cOrgInv;
                logger.info("\u5168\u5c40\u5e93\u5b58\u8c03\u6574\u6570\u4e3a\uff1a{},key:{}", (Object)newInv, (Object)key);
                CargoStorageEo upDto = new CargoStorageEo();
                upDto.setCargoId(key);
                upDto.setAvailable(new BigDecimal(newInv));
                upDto.setUpdateTime(new Date());
                if (SHARE_ALL_INVENTORY.equals(s)) {
                    shareUpdateDtos.add(upDto);
                } else {
                    channelUpdateDtos.add(upDto);
                }
                this.cacheService.setPersistCache(s + NEW_INV + key, (Object)newInv);
                this.cacheService.setPersistCache(s + key, (Object)allInv);
            }
        }
    }

    private void getInv(List<Long> refShareWarehouseIds, List<RefWarehouseEo> warehouseEos, Map<Long, List<CargoStorageEo>> cargoStorageIdMap, Long key, String s, List<CargoStorageEo> shareUpdateDtos, List<CargoStorageEo> channelUpdateDtos) {
        if (CollectionUtils.isNotEmpty(warehouseEos)) {
            Map<String, BigDecimal> refWarehouseMap = warehouseEos.stream().collect(Collectors.toMap(k -> k.getWarehouseId() + k.getRefWarehouseId() + k.getCargoId(), StdRefWarehouseEo::getProportion));
            Map<Long, BigDecimal> cargoStorageAvailableMap = cargoStorageIdMap.get(key).stream().collect(Collectors.toMap(k -> k.getWarehouseId() + k.getCargoId(), StdCargoStorageEo::getAvailable));
            for (Long refWarehouseId : refShareWarehouseIds) {
                BigDecimal sun = BigDecimal.ZERO;
                BigDecimal newSun = BigDecimal.ZERO;
                for (RefWarehouseEo warehouseEo : warehouseEos) {
                    BigDecimal proportion;
                    if (!warehouseEo.getRefWarehouseId().equals(refWarehouseId.toString()) || null == (proportion = refWarehouseMap.get(warehouseEo.getWarehouseId() + refWarehouseId + warehouseEo.getCargoId() + ""))) continue;
                    if (CHANNEL_ORG_INVENTORY.equals(s) && CollectionUtils.isNotEmpty(shareUpdateDtos)) {
                        Map<Long, BigDecimal> shareUpdateMap = shareUpdateDtos.stream().collect(Collectors.toMap(k -> k.getWarehouseId() + k.getCargoId(), StdCargoStorageEo::getAvailable));
                        newSun = shareUpdateMap.get(Long.parseLong(warehouseEo.getWarehouseId()) + warehouseEo.getCargoId()) == null ? BigDecimal.ZERO : shareUpdateMap.get(Long.parseLong(warehouseEo.getWarehouseId()) + warehouseEo.getCargoId());
                    }
                    sun = sun.add(newSun.add(cargoStorageAvailableMap.get(Long.parseLong(warehouseEo.getWarehouseId()) + warehouseEo.getCargoId())).multiply(proportion.divide(new BigDecimal("100"))));
                }
                long orgInv = sun.setScale(0, 1).longValue();
                long oldOmsOrgInv = this.cacheService.getCache(s + refWarehouseId + key, Long.TYPE) == null ? 0L : (Long)this.cacheService.getCache(s + refWarehouseId + key, Long.TYPE);
                logger.info("\u5355\u7ec4\u7ec7\u5e93\u5b58\u539f\u5e93\u5b58\uff1a{},\u65b0\u5e93\u5b58:{}\uff0ckey:{}", new Object[]{oldOmsOrgInv, orgInv, key});
                if (orgInv == oldOmsOrgInv) continue;
                long newInv = orgInv - oldOmsOrgInv;
                logger.info("\u5355\u7ec4\u7ec7\u5e93\u5b58\u8c03\u6574\u6570\u4e3a\uff1a{},key:{}", (Object)newInv, (Object)key);
                CargoStorageEo upDto = new CargoStorageEo();
                upDto.setCargoId(key);
                upDto.setWarehouseId(refWarehouseId);
                upDto.setAvailable(new BigDecimal(newInv));
                upDto.setUpdateTime(new Date());
                if (SHARE_ORG_INVENTORY.equals(s)) {
                    shareUpdateDtos.add(upDto);
                } else {
                    channelUpdateDtos.add(upDto);
                }
                this.cacheService.setPersistCache(s + NEW_INV + refWarehouseId + key, (Object)newInv);
                this.cacheService.setPersistCache(s + refWarehouseId + key, (Object)orgInv);
            }
        }
    }
}

