/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.channel.shipping.beans.ShippingInfo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.MqUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.PackedTraceMessageVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.QueryTraceMessageVo;
import com.dtyunxi.yundt.cube.center.shipping.api.constants.PackageStatusEnum;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IQueryShippingService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingLogService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@MQDesc(tag="query_trace")
public class QueryTraceProcess
implements IMessageProcessor<MessageVo> {
    private Logger logger = LoggerFactory.getLogger(QueryTraceProcess.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IQueryShippingService queryShippingService;
    @Resource
    IPackageService packageService;
    @Resource
    IShippingLogService shippingLogService;
    @Resource
    MqUtils mqUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(MessageVo messageVo) {
        String messageStr = JSON.toJSONString((Object)messageVo);
        this.logger.info("\u83b7\u53d6\u5230\u5e93\u5b58\u4e2d\u5fc3\u67e5\u8be2\u7269\u6d41\u6d88\u606f\uff1a{}", (Object)messageStr);
        if (messageVo == null) {
            this.logger.error("mq\u6d88\u606f\u4f53\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        JSONObject queryTraceMsg = JSON.parseObject((String)String.valueOf(messageVo.getData()));
        QueryTraceMessageVo queryTraceMessageVo = (QueryTraceMessageVo)((Object)JSONObject.toJavaObject((JSON)queryTraceMsg, QueryTraceMessageVo.class));
        List<PackedTraceMessageVo> packedTraceMessageVoList = queryTraceMessageVo.getPackList();
        String cacheKey = "query_trace_out_no" + queryTraceMessageVo.getOutNo() + "time=" + queryTraceMessageVo.getTime();
        boolean isNotExit = this.cacheService.add(cacheKey, (Object)"1");
        if (isNotExit) {
            try {
                ArrayList<PackedTraceMessageVo> newPackList = new ArrayList<PackedTraceMessageVo>();
                for (PackedTraceMessageVo p : packedTraceMessageVoList) {
                    ShippingInfo shippingInfo;
                    if (p.getShippingCompanyId() == null || p.getShippingCompanyId().equals(0L) || (shippingInfo = this.queryShippingService.queryShipping(p.getShippingCompanyId(), p.getShippingNo())) == null) continue;
                    this.shippingLogService.updateLogByShippingNo(p.getTenantId(), p.getInstanceId(), shippingInfo.getShippingNo(), JSON.toJSONString((Object)shippingInfo.getTraces()));
                    if (shippingInfo.getState().equals("3")) {
                        this.packageService.updateStatusById(p.getId(), PackageStatusEnum.SIGNED.getCode());
                        continue;
                    }
                    newPackList.add(p);
                }
                if (CollectionUtils.isEmpty(newPackList)) return MessageResponse.SUCCESS;
                queryTraceMessageVo.setTime(null == queryTraceMessageVo.getTime() ? 1 : queryTraceMessageVo.getTime() + 1);
                queryTraceMessageVo.setPackList(newPackList);
                this.mqUtils.sendQueryTraceMq(queryTraceMessageVo);
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                MessageResponse messageResponse = MessageResponse.ERROR;
                return messageResponse;
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        } else {
            this.logger.info("\u6d88\u606f\u5df2\u7ecf\u5904\u7406\u8fc7\u4e86");
            return MessageResponse.SUCCESS;
        }
    }
}

