/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StoreRejectRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.StoreDictEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer.DeliveryRouteProducer;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryItemService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteRecordService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MQDesc(tag="INVENTORY_DELIVERY_CHANGE_TAG", topic="INVENTORY_DELIVERY_TOPIC")
public class DeliveryChangeProcess
implements IMessageProcessor<DeliveryChangeReqDto> {
    private Logger logger = LoggerFactory.getLogger(DeliveryChangeProcess.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private DeliveryRouteProducer deliveryRouteProducer;
    @Autowired
    private IWarehouseService warehouseService;
    @Autowired
    private WarehouseDas warehouseDas;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private ICargoStorageService cargoStorageService;
    @Resource
    private IDeliveryItemService deliveryItemService;
    @Resource
    private IDeliveryRouteRecordService deliveryRouteRecordService;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;

    public MessageResponse process(DeliveryChangeReqDto deliveryChangeReqDto) {
        Thread.currentThread().setName("CHANGE-DELIVERY-PROCESS-" + deliveryChangeReqDto.getDeliveryNo() + "-" + UUID.randomUUID().toString());
        this.logger.info("\u63a5\u6536\u5230\u66f4\u65b0\u53d1\u8d27\u5355\u72b6\u6001\u4fe1\u606f\uff0cChangeDeliveryReqDto {}", (Object)JSON.toJSONString((Object)deliveryChangeReqDto));
        String deliveryNo = deliveryChangeReqDto.getDeliveryNo();
        OrderDeliveryEo orderDeliverySelect = new OrderDeliveryEo();
        orderDeliverySelect.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        if (null == orderDeliveryEo) {
            this.logger.error("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u4fe1\u606f,deliveryNo:{}", (Object)deliveryNo);
            return MessageResponse.ERROR;
        }
        deliveryChangeReqDto.setPreDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryChangeReqDto.setPreWarehouseCode(orderDeliveryEo.getWarehouseCode());
        deliveryChangeReqDto.setPreWarehouseName(orderDeliveryEo.getWarehouseName());
        OrderDeliveryEo orderDeliveryUpdate = new OrderDeliveryEo();
        orderDeliveryUpdate.setId(orderDeliveryEo.getId());
        orderDeliveryUpdate.setDeliveryStatus(deliveryChangeReqDto.getDeliveryStatus());
        orderDeliveryUpdate.setWarehouseCode(deliveryChangeReqDto.getWarehouseCode());
        orderDeliveryUpdate.setReceiveTime(deliveryChangeReqDto.getReceiveTime());
        orderDeliveryUpdate.setDeliveryTime(deliveryChangeReqDto.getDeliveryTime());
        orderDeliveryUpdate.setOrganizationId(deliveryChangeReqDto.getOrganizationId());
        orderDeliveryUpdate.setOrganizationName(deliveryChangeReqDto.getOrganizationName());
        if (DeliveryRouteOptEnum.RE_ROUTE.getOptCode().equals(deliveryChangeReqDto.getOptCode())) {
            this.logger.info("\u53d1\u8d27\u5355\u91cd\u65b0\u8def\u7531\u64cd\u4f5c\uff0c\u6e05\u7a7a\u4ed3\u5e93\u4fe1\u606f\u2026\u2026");
            orderDeliveryUpdate.clearWarehouse();
        }
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        this.saveRouteRecord(deliveryChangeReqDto);
        Map<String, DictDto> dictDtoMap = this.getDictDtoMap();
        this.handleByRouteOpt(deliveryChangeReqDto, orderDeliveryEo, dictDtoMap);
        return MessageResponse.SUCCESS;
    }

    private void handleByRouteOpt(DeliveryChangeReqDto deliveryChangeReqDto, OrderDeliveryEo orderDeliveryEo, Map<String, DictDto> dictDtoMap) {
        WarehouseRespDto warehouseRespDto = this.getWarehouseByOpt(deliveryChangeReqDto);
        String deliveryNo = deliveryChangeReqDto.getDeliveryNo();
        if (DeliveryRouteOptEnum.REJECT_ORDER.getOptCode().equals(deliveryChangeReqDto.getOptCode()) || DeliveryRouteOptEnum.UNABLE_DELIVER.getOptCode().equals(deliveryChangeReqDto.getOptCode())) {
            this.handleAvailablePreempt(deliveryNo, warehouseRespDto);
        }
        if (DeliveryRouteOptEnum.REJECT_ORDER.getOptCode().equals(deliveryChangeReqDto.getOptCode()) && WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode() == warehouseRespDto.getSubType().intValue()) {
            this.handelRejectCreditValue(deliveryNo, warehouseRespDto, dictDtoMap);
        }
        if (DeliveryRouteOptEnum.UNABLE_DELIVER.getOptCode().equals(deliveryChangeReqDto.getOptCode()) && WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode() == warehouseRespDto.getSubType().intValue()) {
            this.handelUnableDeliverCreditValue(deliveryNo, warehouseRespDto);
        }
        if (DeliveryRouteOptEnum.REJECT_ORDER.getOptCode().equals(deliveryChangeReqDto.getOptCode())) {
            this.handelContinueReject(deliveryNo, warehouseRespDto);
        }
        if (DeliveryRouteOptEnum.RECEIVE_ORDER.getOptCode().equals(deliveryChangeReqDto.getOptCode())) {
            this.handelContinueReceive(deliveryNo, warehouseRespDto);
        }
        if (DeliveryRouteOptEnum.ASSIGN.getOptCode().equals(deliveryChangeReqDto.getOptCode())) {
            this.handleAssign(deliveryNo, warehouseRespDto);
        }
        if (DeliveryRouteOptEnum.DELIVER.getOptCode().equals(deliveryChangeReqDto.getOptCode())) {
            this.handleDeliver(deliveryNo, warehouseRespDto, dictDtoMap);
        }
        if (DeliveryStatusEnum.TO_ROUTE.getStatus().equals(deliveryChangeReqDto.getDeliveryStatus())) {
            this.logger.info("\u53d1\u8d27\u5355\u72b6\u6001\u4e3a\u5f85\u8def\u7531\u72b6\u6001\uff0c\u53d1\u9001\u8def\u7531\u6d88\u606f\uff0cdeliveryNo:{}", (Object)orderDeliveryEo.getDeliveryNo());
            DeliveryRouteReqDto deliveryRouteReqDto = new DeliveryRouteReqDto();
            deliveryRouteReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            this.deliveryRouteProducer.sendDeliberyRoutCommand(deliveryRouteReqDto);
        }
    }

    private WarehouseRespDto getWarehouseByOpt(DeliveryChangeReqDto deliveryChangeReqDto) {
        Object warehouseRespDto = DeliveryRouteOptEnum.REJECT_ORDER.getOptCode().equals(deliveryChangeReqDto.getOptCode()) || DeliveryRouteOptEnum.UNABLE_DELIVER.getOptCode().equals(deliveryChangeReqDto.getOptCode()) ? this.warehouseService.queryByCode(deliveryChangeReqDto.getPreWarehouseCode()) : (DeliveryRouteOptEnum.RE_ROUTE.getOptCode().equals(deliveryChangeReqDto.getOptCode()) || DeliveryRouteOptEnum.CANCEL.getOptCode().equals(deliveryChangeReqDto.getOptCode()) ? null : (StringUtils.isNotEmpty((CharSequence)deliveryChangeReqDto.getWarehouseCode()) ? this.warehouseService.queryByCode(deliveryChangeReqDto.getWarehouseCode()) : null));
        return warehouseRespDto;
    }

    private void saveRouteRecord(DeliveryChangeReqDto deliveryChangeReqDto) {
        RefDeliveryOrderEo refDeliveryOrderSelect = new RefDeliveryOrderEo();
        refDeliveryOrderSelect.setDeliveryNo(deliveryChangeReqDto.getDeliveryNo());
        RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)this.refDeliveryOrderDas.selectOne((BaseEo)refDeliveryOrderSelect);
        DeliveryRouteRecordReqDto deliveryRouteRecord = new DeliveryRouteRecordReqDto();
        if (null != refDeliveryOrderEo) {
            deliveryRouteRecord.setOrderNo(refDeliveryOrderEo.getOrderNo());
        } else {
            this.logger.warn("\u53d1\u8d27\u5355\uff1a{}\u4fdd\u5b58\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u5b8c\u6574\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f\u3002", (Object)deliveryChangeReqDto.getDeliveryNo());
        }
        deliveryRouteRecord.setDeliveryNo(deliveryChangeReqDto.getDeliveryNo());
        deliveryRouteRecord.setOptCode(deliveryChangeReqDto.getOptCode());
        deliveryRouteRecord.setOptName(DeliveryRouteOptEnum.getDescByCode((String)deliveryChangeReqDto.getOptCode()));
        deliveryRouteRecord.setPreDeliveryStatus(deliveryChangeReqDto.getPreDeliveryStatus());
        deliveryRouteRecord.setPreDeliveryStatusName(DeliveryStatusEnum.getMsg((String)deliveryChangeReqDto.getPreDeliveryStatus()));
        deliveryRouteRecord.setDeliveryStatus(deliveryChangeReqDto.getDeliveryStatus());
        deliveryRouteRecord.setDeliveryStatusName(DeliveryStatusEnum.getMsg((String)deliveryChangeReqDto.getDeliveryStatus()));
        if (DeliveryRouteOptEnum.REJECT_ORDER.getOptCode().equals(deliveryChangeReqDto.getOptCode()) || DeliveryRouteOptEnum.UNABLE_DELIVER.getOptCode().equals(deliveryChangeReqDto.getOptCode())) {
            deliveryRouteRecord.setWarehouseCode(deliveryChangeReqDto.getPreWarehouseCode());
            deliveryRouteRecord.setWarehouseName(deliveryChangeReqDto.getPreWarehouseName());
        } else {
            deliveryRouteRecord.setWarehouseCode(deliveryChangeReqDto.getWarehouseCode());
            deliveryRouteRecord.setWarehouseName(deliveryChangeReqDto.getWarehouseName());
        }
        deliveryRouteRecord.setRouteResult(deliveryChangeReqDto.getWarehouseName());
        deliveryRouteRecord.setDetailDesc(deliveryChangeReqDto.getDetailDesc());
        this.deliveryRouteRecordService.saveRouteRecord(deliveryRouteRecord);
    }

    private void handelRejectCreditValue(String deliveryNo, WarehouseRespDto warehouseRespDto, Map<String, DictDto> dictDtoMap) {
        Integer creditValue;
        if (WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode() != warehouseRespDto.getSubType().intValue()) {
            this.logger.info("\u975e\u95e8\u5e97\u4ed3\u62d2\u5355\u4e0d\u8fdb\u884c\u4fe1\u7528\u5206\u6263\u51cf\u64cd\u4f5c");
            return;
        }
        if (null == dictDtoMap || dictDtoMap.isEmpty()) {
            this.logger.warn("\u95e8\u5e97\u8bbe\u7f6e\u672a\u8bbe\u7f6e\uff0c\u4e0d\u8fdb\u884c\u5bf9\u5e94\u7684\u4fe1\u7528\u5206\u589e\u51cf\uff0cwarehouseCode\uff1a{}", (Object)warehouseRespDto.getCode());
            return;
        }
        StoreRejectRespDto storeRejectRespDto = (StoreRejectRespDto)JSON.parseObject((String)dictDtoMap.get(StoreDictEnum.REJECT_ORDER_SETTING.getCode()).getValue(), StoreRejectRespDto.class);
        Integer firstNum = storeRejectRespDto.getFirstNum();
        Integer secondNum = storeRejectRespDto.getSecondNum();
        if (warehouseRespDto.getContinueRejectOrder() + 1 < firstNum) {
            this.logger.info("\u8fde\u7eed\u62d2\u5355\u6b21\u6570\u5c0f\u4e8e\u8bbe\u7f6e\u7684\u7b2c\u4e00\u4e2a\u8fde\u7eed\u62d2\u5355\u6b21\u6570");
            creditValue = storeRejectRespDto.getRejectCreditValue().intValue();
        } else if (warehouseRespDto.getContinueRejectOrder() + 1 >= firstNum && warehouseRespDto.getContinueRejectOrder() + 1 < secondNum) {
            this.logger.info("\u8fde\u7eed\u62d2\u5355\u6b21\u6570\u843d\u5728\u7b2c\u4e00\u4e2a\u8fde\u7eed\u62d2\u5355\u6b21\u6570\u91cc");
            creditValue = storeRejectRespDto.getFirstCreditValue().intValue();
        } else if (warehouseRespDto.getContinueRejectOrder() + 1 >= secondNum) {
            this.logger.info("\u8fde\u7eed\u62d2\u5355\u6b21\u6570\u843d\u5728\u7b2c\u4e8c\u4e2a\u8fde\u7eed\u62d2\u5355\u6b21\u6570\u91cc");
            creditValue = storeRejectRespDto.getSecondCreditValue().intValue();
        } else {
            this.logger.error("\u95e8\u5e97\u8bbe\u7f6e-\u4fe1\u7528-\u62d2\u5355\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u4e0d\u8fdb\u884c\u4fe1\u7528\u5206\u6263\u51cf\uff0c\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)dictDtoMap.get(StoreDictEnum.REJECT_ORDER_SETTING.getCode()).getValue());
            return;
        }
        this.warehouseService.addCreditValue(warehouseRespDto.getCode(), -creditValue.intValue());
        this.logger.info("\u95e8\u5e97\u4ed3\u62d2\u5355\u6263\u51cf\u4fe1\u7528\u5206\uff0c\u53d1\u8d27\u5355\uff1a{}\uff0c\u4ed3\u5e93\uff1a{}\uff0c\u8fde\u7eed\u5355\u6b21\u6570\uff1a{},\u672c\u6b21\u6263\u9664\u5206\u6570\uff1a{}", new Object[]{deliveryNo, warehouseRespDto.getCode(), warehouseRespDto.getContinueRejectOrder() + 1, creditValue});
    }

    private Map<String, DictDto> getDictDtoMap() {
        List dictDtos = (List)this.dictQueryApi.queryByGroupCode(ComConstants.TENANT, "STORE_SETTING").getData();
        if (CollectionUtils.isEmpty((Collection)dictDtos)) {
            return null;
        }
        Map<String, DictDto> dictDtoMap = dictDtos.stream().collect(Collectors.toMap(DictDto::getCode, dictDto -> dictDto));
        return dictDtoMap;
    }

    private void handelUnableDeliverCreditValue(String deliveryNo, WarehouseRespDto warehouseRespDto) {
        List dictDtos = (List)this.dictQueryApi.queryByGroupCode(ComConstants.TENANT, "STORE_SETTING").getData();
        if (CollectionUtils.isEmpty((Collection)dictDtos)) {
            this.logger.warn("\u95e8\u5e97\u8bbe\u7f6e\u672a\u8bbe\u7f6e\uff0c\u4e0d\u8fdb\u884c\u5bf9\u5e94\u7684\u4fe1\u7528\u5206\u589e\u51cf\uff0cwarehouseCode\uff1a{}", (Object)warehouseRespDto.getCode());
            return;
        }
        Map<String, DictDto> dictDtoMap = dictDtos.stream().collect(Collectors.toMap(DictDto::getCode, dictDto -> dictDto));
        DictDto dictDto2 = dictDtoMap.get(StoreDictEnum.UNABLE_DELIVER_SETTING.getCode());
        if (null == dictDto2) {
            this.logger.warn("\u672a\u914d\u7f6e\u65e0\u6cd5\u53d1\u8d27\u6263\u51cf\u4fe1\u7528\u5206\uff0c\u4e0d\u8fdb\u884c\u6263\u51cf\u4fe1\u7528\u503c\u64cd\u4f5c\u3002");
            return;
        }
        Map map = (Map)JSONObject.parseObject((String)dictDto2.getValue(), Map.class);
        Integer creditValue = Integer.parseInt(map.get("value").toString());
        this.warehouseService.addCreditValue(warehouseRespDto.getCode(), -creditValue.intValue());
        this.logger.info("\u95e8\u5e97\u4ed3\u65e0\u6cd5\u53d1\u8d27\u6263\u51cf\u4fe1\u7528\u5206\uff0cdeliveryNo:{}, \u4ed3\u5e93\uff1a{}\uff0c\u8fde\u7eed\u5355\u6b21\u6570\uff1a{},\u672c\u6b21\u6263\u9664\u5206\u6570\uff1a{}", new Object[]{deliveryNo, warehouseRespDto.getCode(), warehouseRespDto.getContinueRejectOrder(), creditValue});
    }

    private void handelContinueReject(String deliveryNo, WarehouseRespDto warehouseRespDto) {
        this.logger.info("\u66f4\u65b0\u4ed3\u5e93\u8fde\u7eed\u62d2\u5355\u6b21\u6570,deliveryNo:{}\uff0cwarehouseCode:{}, continueRejectOrder:{}", new Object[]{deliveryNo, warehouseRespDto.getCode(), warehouseRespDto.getContinueRejectOrder() + 1});
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setId(warehouseRespDto.getId());
        warehouseEo.setContinueRejectOrder(Integer.valueOf(warehouseRespDto.getContinueRejectOrder() + 1));
        warehouseEo.setContinueReceiveOrder(Integer.valueOf(0));
        this.warehouseDas.updateSelective((BaseEo)warehouseEo);
    }

    private void handelContinueReceive(String deliveryNo, WarehouseRespDto warehouseRespDto) {
        this.logger.info("\u66f4\u65b0\u4ed3\u5e93\u8fde\u7eed\u63a5\u5355\u6b21\u6570,deliveryNo:{}\uff0cwarehouseCode:{}, continueReceOrder:{}", new Object[]{deliveryNo, warehouseRespDto.getCode(), warehouseRespDto.getContinueReceiveOrder() + 1});
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setId(warehouseRespDto.getId());
        warehouseEo.setContinueReceiveOrder(Integer.valueOf(warehouseRespDto.getContinueReceiveOrder() + 1));
        warehouseEo.setContinueRejectOrder(Integer.valueOf(0));
        this.warehouseDas.updateSelective((BaseEo)warehouseEo);
    }

    private void handleAvailablePreempt(String deliveryNo, WarehouseRespDto warehouseRespDto) {
        List<DeliveryItemRespDto> deliveryItemRespDtos = this.deliveryItemService.queryByDeliveryNo(deliveryNo);
        if (CollectionUtils.isEmpty(deliveryItemRespDtos)) {
            return;
        }
        for (DeliveryItemRespDto deliveryItemRespDto : deliveryItemRespDtos) {
            if (StringUtils.isEmpty((CharSequence)deliveryItemRespDto.getCargoSerial())) {
                this.logger.info("\u53d1\u8d27\u5355\u8d27\u54c1\u660e\u7ec6\u65e0\u8d27\u54c1\u7f16\u7801, deliveryNo:{}", (Object)deliveryNo);
                continue;
            }
            StorageChangeReqDto storageChangeReqDto = new StorageChangeReqDto();
            storageChangeReqDto.setWarehouseId(warehouseRespDto.getId());
            storageChangeReqDto.setCargoCode(deliveryItemRespDto.getCargoSerial());
            storageChangeReqDto.setPreempt(new BigDecimal(-deliveryItemRespDto.getItemNum().intValue()));
            storageChangeReqDto.setAvailable(new BigDecimal(deliveryItemRespDto.getItemNum()));
            this.cargoStorageService.addAvailablePreempt(storageChangeReqDto);
            this.logger.error("\u53d1\u8d27\u5355\u8fdb\u884c\u62d2\u5355\u3001\u65e0\u6cd5\u53d1\u8d27\u64cd\u4f5c\uff0c\u91ca\u653e\u9884\u5360\u3001\u589e\u52a0\u53ef\u7528\u5e93\u5b58\uff0c\u4ed3\u5e93\uff1a{}-{},\u91ca\u653e\u548c\u589e\u52a0\u6570\u91cf\uff1a{}", new Object[]{warehouseRespDto.getCode(), warehouseRespDto.getName(), deliveryItemRespDto.getItemNum()});
        }
    }

    private void handleAssign(String deliveryNo, WarehouseRespDto warehouseRespDto) {
        this.logger.info("\u53d1\u8d27\u5355\u6307\u6d3e\uff0c\u589e\u52a0\u9884\u5360\uff0c\u51cf\u5c11\u53ef\u7528\u5e93\u5b58\u2026\u2026");
        List<DeliveryItemRespDto> deliveryItemRespDtos = this.deliveryItemService.queryByDeliveryNo(deliveryNo);
        if (CollectionUtils.isEmpty(deliveryItemRespDtos)) {
            return;
        }
        for (DeliveryItemRespDto deliveryItemRespDto : deliveryItemRespDtos) {
            if (StringUtils.isEmpty((CharSequence)deliveryItemRespDto.getCargoSerial())) {
                this.logger.info("\u53d1\u8d27\u5355\u8d27\u54c1\u660e\u7ec6\u65e0\u8d27\u54c1\u7f16\u7801, deliveryNo :{}", (Object)deliveryNo);
                continue;
            }
            StorageChangeReqDto storageChangeReqDto = new StorageChangeReqDto();
            storageChangeReqDto.setWarehouseId(warehouseRespDto.getId());
            storageChangeReqDto.setCargoCode(deliveryItemRespDto.getCargoSerial());
            storageChangeReqDto.setAvailable(new BigDecimal(-deliveryItemRespDto.getItemNum().intValue()));
            storageChangeReqDto.setPreempt(new BigDecimal(deliveryItemRespDto.getItemNum()));
            this.cargoStorageService.addAvailablePreempt(storageChangeReqDto);
            this.logger.error("\u53d1\u8d27\u5355\u8fdb\u884c\u6307\u6d3e\u64cd\u4f5c\uff0c\u589e\u52a0\u9884\u5360\u3001\u51cf\u5c11\u53ef\u7528\u5e93\u5b58\uff0c\u4ed3\u5e93\uff1a{}-{},\u589e\u52a0\u6263\u51cf\u51cf\u5c11\u6570\u91cf\u4e3a\uff1a{}", new Object[]{warehouseRespDto.getCode(), warehouseRespDto.getName(), deliveryItemRespDto.getItemNum()});
        }
    }

    private void handleDeliver(String deliveryNo, WarehouseRespDto warehouseRespDto, Map<String, DictDto> dictDtoMap) {
        List<DeliveryItemRespDto> deliveryItemRespDtos = this.deliveryItemService.queryByDeliveryNo(deliveryNo);
        if (CollectionUtils.isEmpty(deliveryItemRespDtos)) {
            this.logger.error("\u53d1\u8d27\u5355\u53d1\u8d27\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\u2026\u2026");
            return;
        }
        for (DeliveryItemRespDto deliveryItemRespDto : deliveryItemRespDtos) {
            if (StringUtils.isEmpty((CharSequence)deliveryItemRespDto.getCargoSerial())) {
                this.logger.info("\u7b49\u53d1\u8d27\u5355\u8d27\u54c1\u660e\u7ec6\u65e0\u8d27\u54c1\u7f16\u7801, deliveryNo :{}", (Object)deliveryNo);
                continue;
            }
            StorageChangeReqDto storageChangeReqDto = new StorageChangeReqDto();
            storageChangeReqDto.setWarehouseId(warehouseRespDto.getId());
            storageChangeReqDto.setCargoCode(deliveryItemRespDto.getCargoSerial());
            storageChangeReqDto.setBalance(new BigDecimal(-deliveryItemRespDto.getItemNum().intValue()));
            storageChangeReqDto.setPreempt(new BigDecimal(-deliveryItemRespDto.getItemNum().intValue()));
            this.cargoStorageService.changeCargoStorageNum(storageChangeReqDto);
            this.logger.info("\u53d1\u8d27\u5355\u8fdb\u884c\u53d1\u8d27\u64cd\u4f5c\uff0c\u603b\u5e93\u5b58\u3001\u9884\u5360\u5e93\u5b58\u51cf\u5c11\uff0c\u4ed3\u5e93\uff1a{}-{},\u6263\u51cf\u51cf\u5c11\u6570\u91cf\uff1a{}", new Object[]{warehouseRespDto.getCode(), warehouseRespDto.getName(), deliveryItemRespDto.getItemNum()});
        }
        if (WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode() != warehouseRespDto.getSubType().intValue()) {
            this.logger.info("\u975e\u95e8\u5e97\u4e0d\u8fdb\u884c\u53d1\u8d27\u9608\u503c\u5904\u7406\uff01");
            return;
        }
        if (null != dictDtoMap && null != dictDtoMap.get(StoreDictEnum.STORE_DELIVERY_THRESHOLD_SETTING.getCode())) {
            String thresholdJson = dictDtoMap.get(StoreDictEnum.STORE_DELIVERY_THRESHOLD_SETTING.getCode()).getValue();
            Map map = (Map)JSONObject.parseObject((String)thresholdJson, Map.class);
            Integer thresholdValue = Integer.parseInt(map.get("value").toString());
            this.warehouseDas.addThresholdLeftAndScore(warehouseRespDto.getCode(), Integer.valueOf(-1), Integer.valueOf(-thresholdValue.intValue()));
            this.logger.info("\u53d1\u8d27\u6210\u529f\uff0c\u5bf9\u95e8\u5e97\uff1a{}-{}\u8fdb\u884c\u9608\u503c\u5904\u7406\uff0c\u51cf\u5c11\u5269\u4f59\u53d1\u8d27\u9608\u503c{}\uff0c\u51cf\u5c11\u9608\u503c\u5206\uff1a{}", new Object[]{warehouseRespDto.getCode(), warehouseRespDto.getName(), 1, thresholdValue});
        } else {
            this.logger.info("\u95e8\u5e97\uff1a{}-{}\u53d1\u8d27\u9608\u503c\u8bbe\u7f6e\u672a\u8bbe\u7f6e\uff0c\u4e0d\u8fdb\u884c\u5269\u4f59\u53d1\u8d27\u9608\u503c\u548c\u9608\u503c\u5206\u7684\u66f4\u65b0\u3002", (Object)warehouseRespDto.getCode(), (Object)warehouseRespDto.getName());
        }
    }
}

